/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MobSpawnCategory;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;

public class GetSpawnStateCommand
extends Command<MythicBukkit> {
    public GetSpawnStateCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player player = (Player)sender;
        AbstractLocation location = BukkitAdapter.adapt(player.getLocation());
        MythicSpawnState state = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getSpawningHandler().getSpawnState(location.getWorld());
        CommandHelper.sendSuccess(sender, "<white>Spawnable Chunks <gray>>> <white>" + state.getSpawnableChunkCount());
        CommandHelper.sendSuccess(sender, "<white>Max Mobs Count <gray>>> <white>" + state.getMaxMobCount());
        CommandHelper.sendSuccess(sender, "<white>GameRule MobSpawning: " + player.getWorld().getGameRuleValue(GameRule.DO_MOB_SPAWNING));
        int nx = location.getBlockX();
        int nz = location.getBlockZ();
        int maxHeight = player.getLocation().getChunk().getChunkSnapshot(true, false, false).getHighestBlockYAt(Math.abs(nx % 16), Math.abs(nz % 16)) + 1;
        int minHeight = player.getLocation().getWorld().getMinHeight();
        CommandHelper.sendSuccess(sender, "<white>Spawn Y Range <gray>>> <white>" + minHeight + " <gray>to <white>" + maxHeight);
        CommandHelper.sendSuccess(sender, "Bukkit Monster Spawn Time " + Bukkit.getTicksPerSpawns((SpawnCategory)SpawnCategory.MONSTER));
        CommandHelper.sendSuccess(sender, "Bukkit Monster Spawn Limit " + Bukkit.getSpawnLimit((SpawnCategory)SpawnCategory.MONSTER));
        Location loc = player.getLocation();
        World world = loc.getWorld();
        CommandHelper.sendSuccess(sender, "World Monster Spawn Time " + world.getTicksPerSpawns(SpawnCategory.MONSTER));
        CommandHelper.sendSuccess(sender, "World Monster Spawn Limit " + world.getSpawnLimit(SpawnCategory.MONSTER));
        int limit = world.getSpawnLimit(SpawnCategory.MONSTER);
        int chunks = world.getLoadedChunks().length;
        limit = limit * chunks / 289;
        CommandHelper.sendSuccess(sender, "Real Monster Spawn Limit " + limit);
        CommandHelper.sendSuccess(sender, "<white>Current Mob Counts:");
        for (Map.Entry<MobSpawnCategory, Integer> entry : state.getCurrentMobCounts().entrySet()) {
            try {
                CommandHelper.sendSuccess(sender, "<gold>-- <yellow>" + entry.getKey().getName() + "<gray>: <white>" + entry.getValue());
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.test.spawncheck";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "getspawnstate";
    }
}

