/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class RemoveConditionCommand
extends Command<MythicBukkit> {
    public RemoveConditionCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.YELLOW + "Command: " + ChatColor.AQUA + "/mm spawners removecondition [condition]");
            sender.sendMessage(ChatColor.YELLOW + "View conditions on the Manual @ http://www.mythicmobs.net");
            return true;
        }
        String name = args[0];
        String condition = args[1];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicBukkit.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (MythicBukkit.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " was removed on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
                if (MythicBukkit.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " removed from all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || MythicBukkit.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " removed from spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicBukkit.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return true;
            }
            if (!MythicBukkit.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The attribute or value you entered was invalid!");
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " has been removed!");
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.removecondition";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "removecondition";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"rc"};
    }
}

