/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.commands.Command;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoveCommand
extends Command<MythicBukkit> {
    public MoveCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a spawner to move.");
            return true;
        }
        String name = args[0];
        if (MythicBukkit.inst().getSpawnerManager().getSpawnerByName(name) == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner to move!");
            return true;
        }
        Player p = (Player)sender;
        Location location = p.getTargetBlock((Set)null, 10).getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block to move the spawner!");
            return true;
        }
        if (MythicBukkit.inst().getSpawnerManager().moveSpawner(name, BukkitAdapter.adapt(location))) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
            location.getWorld().playEffect(location, Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner " + name + " was moved successfully!");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.move";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "move";
    }
}

