/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class InfoCommand
extends Command<MythicBukkit> {
    public InfoCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a mob spawner!");
            return true;
        }
        String name = args[0];
        MythicSpawner ms = MythicBukkit.inst().getSpawnerManager().getSpawnerByName(name);
        if (ms == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The spawner entered does not exist!");
            return true;
        }
        MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(ms.getTypeName()).orElseGet(() -> null);
        sender.sendMessage(ChatColor.GOLD + "Stats for Spawner " + ChatColor.BOLD + ChatColor.GRAY + ms.getName() + ":");
        sender.sendMessage(ChatColor.GOLD + "Location: " + ChatColor.GRAY + ms.getLocation().getBlockX() + "," + ms.getLocation().getBlockY() + "," + ms.getLocation().getBlockZ() + "@" + ms.getLocation().getWorld().getName());
        sender.sendMessage(ChatColor.GOLD + "MobSpawn: " + ChatColor.GRAY + mm4.getInternalName());
        sender.sendMessage(ChatColor.GOLD + "Group: " + ChatColor.GRAY + ms.getGroup());
        sender.sendMessage(ColorString.get("&6MaxMobs&7: &f" + ms.getMaxMobs().serialize() + "&7(Currently: &e" + ms.getMaxMobs().get(ms) + "&7)"));
        sender.sendMessage(ChatColor.GOLD + "MobLevel: " + ChatColor.GRAY + ms.getMobLevel());
        sender.sendMessage(ChatColor.GOLD + "MobsPerSpawn: " + ChatColor.GRAY + ms.getMobsPerSpawn());
        sender.sendMessage(ChatColor.GOLD + "SpawnRadius: " + ChatColor.GRAY + ms.getSpawnRadius());
        sender.sendMessage(ChatColor.GOLD + "SpawnRadiusY: " + ChatColor.GRAY + ms.getSpawnRadiusY());
        sender.sendMessage(ChatColor.GOLD + "ActivationRange: " + ChatColor.GRAY + ms.getActivationRange());
        sender.sendMessage(ChatColor.GOLD + "LeashRange: " + ChatColor.GRAY + ms.getLeashRange());
        sender.sendMessage(ChatColor.GOLD + "HealOnLeash: " + ChatColor.GRAY + ms.isHealOnLeash());
        sender.sendMessage(ChatColor.GOLD + "Cooldown: " + ChatColor.GRAY + ms.getCooldownSeconds());
        sender.sendMessage(ChatColor.GOLD + "Warmup: " + ChatColor.GRAY + ms.getWarmupSeconds());
        sender.sendMessage(ChatColor.GOLD + "Breakable: " + ChatColor.GRAY + ms.isBreakable());
        sender.sendMessage(ChatColor.GOLD + "Conditions: " + ChatColor.GRAY + ms.getConditionList().toString());
        sender.sendMessage(ChatColor.RED + "Current # Mobs Spawned: " + ChatColor.GRAY + ms.getNumberOfMobs() + " mobs (Cached: " + ms.getNumberOfCachedMobs() + ")");
        sender.sendMessage(ChatColor.RED + "Spawner On Cooldown: " + ChatColor.WHITE + ms.isOnCooldown() + " (" + ChatColor.GRAY + ms.getRemainingCooldownSeconds() + " seconds)");
        sender.sendMessage(ChatColor.RED + "Spawner On Warmup: " + ChatColor.WHITE + ms.isOnWarmup() + " (" + ChatColor.GRAY + ms.getRemainingWarmupSeconds() + " seconds)");
        sender.sendMessage(ChatColor.RED + "Spawner Internal Cooldown: " + ChatColor.GRAY + ms.getInternalCooldown() + " ticks");
        if (ConfigExecutor.debugLevel > 0) {
            sender.sendMessage(ChatColor.YELLOW + "Associated Mobs: " + ChatColor.AQUA + ms.getAssociatedMobs().toString());
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.info";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "info";
    }
}

