/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.clock;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class MythicClock
extends ReloadableModule<MythicBukkit> {
    private Task secondPassClock;
    private Task syncClock;
    private Task savingClock;
    private Task spawningClock;
    private Task randomSpawningClock;
    private Task skillClock;
    private Task threatClock;
    private int ticker;
    private long skillClockIteration = 0L;
    private List<Runnable> secondPass = Lists.newArrayList();
    private List<Runnable> postReload = Lists.newArrayList();
    private ReentrantLock loadingLock = new ReentrantLock();
    private boolean reloadingPause = false;

    public MythicClock(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        ConfigExecutor configManager = plugin.getConfiguration();
        this.secondPassClock = Schedulers.sync().runRepeating(this::runSecondPass, 20L, 20L);
        this.syncClock = Schedulers.sync().runRepeating(this::runSyncClock, 0L, (long)configManager.getClockIntervalMain());
        this.savingClock = Schedulers.sync().runRepeating(this::runSavingClock, 0L, (long)(ConfigExecutor.SaveInteval * 20));
        this.spawningClock = Schedulers.sync().runRepeating(this::runSpawningClock, 0L, (long)(ConfigExecutor.SpawningInterval * 20));
        this.randomSpawningClock = Schedulers.sync().runRepeating(this::runRandomSpawningClock, 0L, (long)configManager.getClockIntervalRandomSpawning());
        if (ConfigExecutor.EnableThreatTables) {
            this.threatClock = Schedulers.sync().runRepeating(this::runThreatClock, 0L, 20L);
        }
        if (ConfigExecutor.EnableTimerSkills) {
            this.skillClock = Schedulers.async().runRepeating(this::runSkillClock, 0L, (long)configManager.getClockIntervalMain());
        }
    }

    @Override
    public void unload() {
        if (this.secondPassClock != null) {
            this.secondPassClock.terminate();
        }
        if (this.syncClock != null) {
            this.syncClock.terminate();
        }
        if (this.savingClock != null) {
            this.savingClock.terminate();
        }
        if (this.skillClock != null) {
            this.skillClock.terminate();
        }
        if (this.spawningClock != null) {
            this.spawningClock.terminate();
        }
        if (this.randomSpawningClock != null) {
            this.randomSpawningClock.terminate();
        }
        if (this.threatClock != null) {
            this.threatClock.terminate();
        }
    }

    public void setReloadingPause(boolean b) {
        this.loadingLock.lock();
        try {
            this.reloadingPause = b;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void runSecondPass() {
        this.loadingLock.lock();
        try {
            if (this.reloadingPause || this.secondPass.isEmpty()) {
                return;
            }
            while (!this.secondPass.isEmpty()) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Doing second pass on " + this.secondPass.size() + " skills.", new Object[0]);
                ArrayList run = Lists.newArrayList(this.secondPass);
                this.secondPass.clear();
                run.forEach(r -> {
                    if (r != null) {
                        try {
                            r.run();
                        }
                        catch (Error | Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public void queueAfterLoad(Runnable r) {
        Schedulers.sync().runLater(r, 5L);
    }

    public void queuePostReload(Runnable r) {
        this.postReload.add(r);
    }

    public void runPostReload() {
        while (!this.postReload.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Doing post-reload pass on " + this.postReload.size() + " skills.", new Object[0]);
            ArrayList run = Lists.newArrayList(this.postReload);
            this.postReload.clear();
            run.forEach(r -> {
                if (r != null) {
                    try {
                        r.run();
                    }
                    catch (Error | Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public void runSyncClock() {
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Main clock fired", new Object[0]);
        this.ticker += ((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain();
        if (this.ticker > 20) {
            ((MythicBukkit)this.getPlugin()).getEntityManager().refreshCaches();
            this.ticker = 0;
        }
    }

    public void runSavingClock() {
        this.executeSave();
    }

    public void runSkillClock() {
        if (this.reloadingPause) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Skill clock fired", new Object[0]);
        ++this.skillClockIteration;
        ((MythicBukkit)this.getPlugin()).getSkillManager().runTimerSkills(this.skillClockIteration);
    }

    public void runSpawningClock() {
        if (this.reloadingPause) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Spawner clock fired", new Object[0]);
        if (!ConfigExecutor.debugSpawners) {
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSpawnersNew();
            ((MythicBukkit)this.getPlugin()).getSpawnerManager().tickSpawnerClocks();
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSpawnersComplete();
        }
    }

    public void runRandomSpawningClock() {
        if (this.reloadingPause) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Random Spawneing clock fired", new Object[0]);
        if (!ConfigExecutor.debugSpawners) {
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markRandomSpawnersNew();
            ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().spawnMobs();
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markRandomSpawnersComplete();
        }
    }

    public void runThreatClock() {
        if (this.reloadingPause) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Threat clock fired", new Object[0]);
        ((MythicBukkit)this.getPlugin()).getTimingsHandler().markThreatTablesNew();
        ((MythicBukkit)this.getPlugin()).getMobManager().getMobsInCombat().forEach(am -> am.getThreatTable().tickThreat());
        ((MythicBukkit)this.getPlugin()).getTimingsHandler().markThreatTablesComplete();
    }

    public void runCleanupClock() {
    }

    private void executeSave() {
        ((MythicBukkit)this.getPlugin()).getConfiguration().save();
    }
}

