/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters.bossbars;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.adventure.bossbar.BossBar;
import io.lumine.mythic.bukkit.utils.text.Text;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class AdventureBossBar
implements AbstractBossBar {
    private final Set<UUID> players = Sets.newHashSet();
    private final Set<UUID> unmodifiablePlayers;
    BossBar bar;

    public AdventureBossBar(String title, float progress, AbstractBossBar.BarColor color, AbstractBossBar.BarStyle style) {
        this.bar = BossBar.bossBar(Text.parse(title), progress, BossBar.Color.valueOf(color.name()), this.getOverlay(style));
        this.unmodifiablePlayers = Collections.unmodifiableSet(this.players);
    }

    @Override
    public String getTitle() {
        return this.bar.examinableName();
    }

    @Override
    public void setTitle(String title) {
        this.bar.name(Text.parse(title));
    }

    @Override
    public AbstractBossBar.BarColor getColor() {
        return AbstractBossBar.BarColor.valueOf(this.bar.color().name());
    }

    @Override
    public void setColor(String color) {
        this.bar.color(BossBar.Color.valueOf(color));
    }

    @Override
    public AbstractBossBar.BarStyle getStyle() {
        return null;
    }

    @Override
    public void setStyle(String style) {
        if (style.toLowerCase().contains("solid") || style.toLowerCase().contains("segmented")) {
            this.bar.overlay(this.getOverlay(AbstractBossBar.BarStyle.valueOf(style)));
        } else {
            this.bar.overlay(BossBar.Overlay.valueOf(style));
        }
    }

    @Override
    public void removeFlag(String flag) {
        this.bar.removeFlag(BossBar.Flag.valueOf(flag));
    }

    @Override
    public void addFlag(String flag) {
        this.bar.addFlag(BossBar.Flag.valueOf(flag));
    }

    @Override
    public boolean hasFlag(String flag) {
        return this.bar.hasFlag(BossBar.Flag.valueOf(flag));
    }

    @Override
    public void setProgress(double progress) {
        this.bar.progress((float)progress);
    }

    @Override
    public double getProgress() {
        return this.bar.progress();
    }

    @Override
    public void addPlayer(AbstractPlayer player) {
        this.players.add(player.getUniqueId());
        MythicBukkit.inst().adventure().player(player.getUniqueId()).showBossBar(this.bar);
    }

    @Override
    public void removePlayer(AbstractPlayer player) {
        this.players.remove(player.getUniqueId());
        MythicBukkit.inst().adventure().player(player.getUniqueId()).hideBossBar(this.bar);
    }

    @Override
    public void removeAll() {
        this.players.clear();
        MythicBukkit.inst().adventure().players().hideBossBar(this.bar);
    }

    @Override
    public Collection<AbstractPlayer> getPlayers() {
        Collection players = this.players.stream().map(uuid -> MythicBukkit.inst().getBootstrap().getPlayer((UUID)uuid)).collect(Collectors.toSet());
        players.removeAll(Collections.singletonList(null));
        return players;
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setCreateFog(boolean b) {
        if (b) {
            this.bar.addFlag(BossBar.Flag.CREATE_WORLD_FOG);
        } else {
            this.bar.removeFlag(BossBar.Flag.CREATE_WORLD_FOG);
        }
    }

    @Override
    public void setDarkenSky(boolean b) {
        if (b) {
            this.bar.addFlag(BossBar.Flag.DARKEN_SCREEN);
        } else {
            this.bar.removeFlag(BossBar.Flag.DARKEN_SCREEN);
        }
    }

    @Override
    public void setPlayBossMusic(boolean b) {
        if (b) {
            this.bar.addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        } else {
            this.bar.removeFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
    }

    @Override
    public Collection<UUID> getPlayerIds() {
        return this.unmodifiablePlayers;
    }

    @Override
    public void removePlayer(UUID player) {
        this.players.remove(player);
        MythicBukkit.inst().adventure().player(player).hideBossBar(this.bar);
    }

    @Override
    public boolean isViewing(AbstractPlayer player) {
        return this.players.contains(player.getUniqueId());
    }

    @Override
    public void close() {
        this.removeAll();
    }

    private BossBar.Overlay getOverlay(AbstractBossBar.BarStyle barStyle) {
        switch (barStyle) {
            case SEGMENTED_6: {
                return BossBar.Overlay.NOTCHED_6;
            }
            case SEGMENTED_10: {
                return BossBar.Overlay.NOTCHED_10;
            }
            case SEGMENTED_12: {
                return BossBar.Overlay.NOTCHED_12;
            }
            case SEGMENTED_20: {
                return BossBar.Overlay.NOTCHED_20;
            }
        }
        return BossBar.Overlay.PROGRESS;
    }
}

