/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public enum BukkitParticle {
    EXPLOSION_NORMAL("poof", "explode", "explosion", "explosion_small"),
    EXPLOSION_LARGE("largeexplode", "largeexplosion"),
    EXPLOSION_HUGE("explosion_emitter", "hugeexplode", "hugeexplosion"),
    FIREWORKS_SPARK("firework", "fireworksspark"),
    WATER_BUBBLE("bubble"),
    WATER_SPLASH("splash"),
    WATER_WAKE("fishing", "wake"),
    SUSPENDED("underwater"),
    SUSPENDED_DEPTH("underwater", "depthsuspend"),
    CRIT("crit"),
    CRIT_MAGIC("enchanted_hit", "magiccrit"),
    SMOKE_NORMAL("smoke"),
    SMOKE_LARGE("large_smoke", "largesmoke"),
    SPELL("effect"),
    SPELL_INSTANT("instant_effect", "instantSpell"),
    SPELL_MOB("entity_effect", "mobSpell"),
    SPELL_MOB_AMBIENT("ambient_entity_effect", "mobSpellAmbient"),
    SPELL_WITCH("witch", "witchMagic"),
    DRIP_WATER("dripping_water", "dripWater"),
    DRIP_LAVA("dripping_lava", "dripLava"),
    VILLAGER_ANGRY("angry_villager", "angryVillager"),
    VILLAGER_HAPPY("happy_villager", "happyVillager"),
    TOWN_AURA("mycelium", "townaura"),
    NOTE("note"),
    PORTAL("portal"),
    ENCHANTMENT_TABLE("enchant", "enchantmenttable", "enchantingtable"),
    FLAME("flame"),
    LAVA("lava"),
    CLOUD("cloud"),
    REDSTONE("dust", "reddust"),
    SNOWBALL("item_snowball", "snowballpoof"),
    SNOW_SHOVEL("item_snowball", "snowshovel"),
    SLIME("item_slime"),
    HEART("heart"),
    BARRIER("barrier"),
    ITEM_CRACK("item", "iconcrack", "itemcrack"),
    BLOCK_CRACK("block", "blockcrack"),
    BLOCK_DUST("dust", "blockdust"),
    WATER_DROP("rain", "droplet"),
    MOB_APPEARANCE("elder_guardian", "mobappearance"),
    DRAGON_BREATH("dragon_breath", "dragonbreath"),
    END_ROD("end_rod", "endRod"),
    DAMAGE_INDICATOR("damage_indicator", "damageIndicator"),
    SWEEP_ATTACK("sweep_attack", "sweepAttack"),
    FALLING_DUST("falling_dust", "fallingDust"),
    TOTEM("totem_of_undying"),
    SPIT("spit"),
    SQUID_INK("squid_ink", "squidink"),
    BUBBLE_POP("bubble_pop", "bubblepop"),
    CURRENT_DOWN("current_down", "currentdown"),
    BUBBLE_COLUMN_UP("bubble_column_up", "bubblecolumn", "bubble_column"),
    NAUTILUS("nautilus"),
    DOLPHIN("dolphin"),
    COMPOSTER("composter"),
    FALLING_LAVA("fallinglava", "falling_lava"),
    FALLING_WATER("fallingwater", "falling_water"),
    FLASH("flash"),
    LANDING_LAVA("landinglava", "landing_lava"),
    SNEEZE("sneeze"),
    SNOWFLAKE(new String[0]),
    CAMPFIRE_COSY_SMOKE("campfire_cosy_smoke", "campfire_cosy", "campfire_cozy_smoke", "campfire_cozy", "campfire"),
    CAMPFIRE_SIGNAL_SMOKE("campfire_signal_smoke", "campfire_signal"),
    DRIPPING_HONEY("drippinghoney"),
    FALLING_HONEY("fallinghoney"),
    FALLING_NECTAR("fallingnectar"),
    LANDING_HONEY("landinghoney"),
    ASH("ash"),
    WHITE_ASH(new String[0]),
    CRIMSON_SPORE("crimson_spore", "crimson_spores", "crimsonspore", "crimsonspores"),
    SOUL_FIRE_FLAME("soul_fire_flame", "soulfireflame", "soulfire", "soulflame"),
    WARPED_SPORE("warped_spore", "warped_spores", "warpedspore", "warpedspores"),
    DRIPPING_OBSIDIAN_TEAR("dropping_obsidian_tear", "drippingobsidiantear"),
    FALLING_OBSIDIAN_TEAR("falling_obsidian_tear", "fallingobsidiantear"),
    LANDING_OBSIDIAN_TEAR("landing_obsidian_tear", "landingobsidiantear"),
    SOUL("soul"),
    DRIPPING_DRIPSTONE_LAVA("drippingdripstonelava", "droppingdripstonelava"),
    DRIPPING_DRIPSTONE_WATER("drippingdripstonewater", "droppingdripstonewater"),
    DUST_COLOR_TRANSITION("dustcolortransition", "dustcolor"),
    ELECTRIC_SPARK("electricspark", "spark"),
    FALLING_DRIPSTONE_LAVA(new String[0]),
    FALLING_DRIPSTONE_WATER(new String[0]),
    GLOW(new String[0]),
    GLOW_SQUID_INK("glowingink", "glowink", "glowsquid"),
    LIGHT(new String[0]),
    REVERSE_PORTAL(new String[0]),
    SCRAPE(new String[0]),
    SMALL_FLAME(new String[0]),
    VIBRATION(new String[0]),
    WAX_OFF(new String[0]),
    WAX_ON(new String[0]),
    FALLING_SPORE_BLOSSOM("fallingsporeblossom"),
    SPORE_BLOSSOM_AIR("sporeblossomair"),
    BLOCK_MARKER("blockmarker"),
    SCULK_SOUL("skulksoul"),
    SHRIEK(new String[0]),
    SCULK_CHARGE("sculkcharge"),
    SCULK_CHARGE_POP("sculkchargepop"),
    SONIC_BOOM("sonicboom"),
    CHERRY_LEAVES("cherryleaves"),
    DRIPPING_CHERRY_LEAVES("drippingcherryleaves"),
    FALLING_CHERRY_LEAVES("fallingcherryleaves"),
    LANDING_CHERRY_LEAVES("landingcherryleaves"),
    EGG_CRACK("eggcrack");

    private static final Map<String, BukkitParticle> PARTICLE_ALIASES;
    private final String[] aliases;

    public static BukkitParticle get(String key) {
        BukkitParticle particle = PARTICLE_ALIASES.getOrDefault(key.toUpperCase(), null);
        if (particle == null) {
            MythicLogger.errorGenericConfig("Particle '" + key + "' is not supported by this version of MythicMobs.");
            return CLOUD;
        }
        return particle;
    }

    private BukkitParticle(String ... aliases) {
        this.aliases = aliases;
    }

    public Particle toBukkitParticle() {
        return Particle.valueOf((String)this.toString());
    }

    public boolean requiresData() {
        return !this.toBukkitParticle().getDataType().equals(Void.class);
    }

    public boolean validateData(Object obj) {
        Particle particle = this.toBukkitParticle();
        if (particle.getDataType().equals(Void.class)) {
            return false;
        }
        if (particle.getDataType().equals(ItemStack.class)) {
            return obj instanceof ItemStack;
        }
        if (particle.getDataType() == BlockData.class) {
            return obj instanceof BlockData;
        }
        if (particle.getDataType() == MaterialData.class) {
            return obj instanceof MaterialData;
        }
        if (particle.getDataType() == Particle.DustOptions.class) {
            return obj instanceof Particle.DustOptions;
        }
        if (particle.getDataType() == Particle.DustTransition.class) {
            return obj instanceof Particle.DustTransition;
        }
        return true;
    }

    public Object parseDataOptions(MythicLineConfig config) {
        Particle particle = this.toBukkitParticle();
        if (particle.getDataType().equals(ItemStack.class)) {
            String strMaterial = config.getString(new String[]{"material", "m"}, "STONE", new String[0]);
            try {
                return new ItemStack(Material.matchMaterial((String)strMaterial.toUpperCase()));
            }
            catch (Exception ex) {
                return new ItemStack(Material.STONE);
            }
        }
        if (particle.getDataType().equals(BlockData.class)) {
            String strMaterial = config.getString(new String[]{"material", "m"}, "STONE", new String[0]);
            try {
                Material material = Material.matchMaterial((String)strMaterial.toUpperCase());
                return Bukkit.getServer().createBlockData(material);
            }
            catch (Exception ex) {
                return Bukkit.getServer().createBlockData(Material.STONE);
            }
        }
        if (particle.getDataType().equals(MaterialData.class)) {
            String strMaterial = config.getString(new String[]{"material", "m"}, "STONE", new String[0]);
            try {
                Material.matchMaterial((String)strMaterial.toUpperCase()).getData();
            }
            catch (Exception ex) {
                return Material.STONE.getData();
            }
        }
        if (particle.getDataType().equals(Particle.DustOptions.class)) {
            String strColor = config.getString(new String[]{"color", "c"}, "#FF0000", new String[0]);
            Color color = Color.decode(strColor);
            float size = config.getFloat(new String[]{"size"}, 1.0f);
            int r = color.getRed();
            int g2 = color.getGreen();
            int b = color.getBlue();
            org.bukkit.Color c = org.bukkit.Color.fromRGB((int)r, (int)g2, (int)b);
            return new Particle.DustOptions(c, size);
        }
        if (particle.getDataType().equals(Particle.DustTransition.class)) {
            String strColor1 = config.getString(new String[]{"color", "c", "color1", "c1", "fromcolor", "fc"}, "#FF0000", new String[0]);
            Color color1 = Color.decode(strColor1);
            float size = config.getFloat(new String[]{"size"}, 1.0f);
            int r1 = color1.getRed();
            int g1 = color1.getGreen();
            int b1 = color1.getBlue();
            org.bukkit.Color fromColor = org.bukkit.Color.fromRGB((int)r1, (int)g1, (int)b1);
            String strColor2 = config.getString(new String[]{"color2", "c2", "tocolor", "tc"}, "#0000FF", new String[0]);
            Color color2 = Color.decode(strColor2);
            int r2 = color2.getRed();
            int g2 = color2.getGreen();
            int b2 = color2.getBlue();
            org.bukkit.Color toColor = org.bukkit.Color.fromRGB((int)r2, (int)g2, (int)b2);
            return new Particle.DustTransition(fromColor, toColor, size);
        }
        if (particle == Particle.SCULK_CHARGE || particle == Particle.SCULK_CHARGE_POP) {
            String[] stringArray = new String[]{"rotation", "rot", "r"};
            double rotation = config.getDouble(stringArray, 0.0);
            if (rotation > 0.0) {
                rotation = rotation / 180.0 * Math.PI;
            }
            return rotation;
        }
        if (particle == Particle.SHRIEK) {
            return 0;
        }
        return null;
    }

    public void send(AbstractLocation location) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.spawnParticle(particle, loc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void send(AbstractPlayer audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        Player player = (Player)audience.getBukkitEntity();
        player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
    }

    public void send(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        for (AbstractPlayer e : audience) {
            Player player = BukkitAdapter.adapt(e.asPlayer());
            if (!player.getWorld().equals(loc.getWorld())) continue;
            player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
        }
    }

    public void send(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, Object data) {
        this.send(audience, location, speed, amount, offsetX, offsetY, offsetZ, data, false);
    }

    public void send(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, Object data, boolean exactOffsets) {
        if (!this.validateData(data)) {
            MythicLogger.error("Could not send particle: invalid particle data supplied.");
            return;
        }
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        if (exactOffsets) {
            for (int i = 0; i < amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
                for (AbstractPlayer e : audience) {
                    Player player = BukkitAdapter.adapt(e.asPlayer());
                    if (!player.getWorld().equals(loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 1, 0.0, 0.0, 0.0, (double)speed);
                }
            }
        } else {
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals(loc.getWorld())) continue;
                player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, data);
            }
        }
    }

    public void sendDirectional(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, AbstractVector direction) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        for (int i = 0; i < amount; ++i) {
            Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals(loc.getWorld())) continue;
                player.spawnParticle(particle, ln, 0, (double)((float)direction.getX()), (double)((float)direction.getY()), (double)((float)direction.getZ()), (double)speed);
            }
        }
    }

    public void sendLegacyColored(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, Color color) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        float r = (float)color.getRed() / 255.0f;
        float g2 = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        if (r < Float.MIN_NORMAL) {
            r = Float.MIN_NORMAL;
        }
        for (int i = 0; i < amount; ++i) {
            Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals(loc.getWorld())) continue;
                player.spawnParticle(particle, ln, 0, (double)r, (double)g2, (double)b, speed > 0.0f ? (double)speed : 1.0);
            }
        }
    }

    public String[] getAliases() {
        return this.aliases;
    }

    static {
        PARTICLE_ALIASES = new HashMap<String, BukkitParticle>();
        for (BukkitParticle particle : BukkitParticle.values()) {
            PARTICLE_ALIASES.put(particle.toString(), particle);
            PARTICLE_ALIASES.put(particle.toString().replace("_", ""), particle);
            for (String alias : particle.getAliases()) {
                PARTICLE_ALIASES.put(alias.toUpperCase(), particle);
            }
        }
    }
}

