/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.exceptions.InvalidMobTypeException;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class BukkitAPIHelper {
    public MythicMob getMythicMob(String type) {
        return MythicBukkit.inst().getMobManager().getMythicMob(type).orElseGet(() -> null);
    }

    public Entity spawnMythicMob(MythicMob type, Location location, int level) throws InvalidMobTypeException {
        if (type == null) {
            throw new InvalidMobTypeException("Supplied mob type cannot be null.");
        }
        return type.spawn(BukkitAdapter.adapt(location), level, SpawnReason.OTHER).getEntity().getBukkitEntity();
    }

    public Entity spawnMythicMob(String type, Location location) throws InvalidMobTypeException {
        return this.spawnMythicMob(type, location, 1);
    }

    public Entity spawnMythicMob(String type, Location location, int level) throws InvalidMobTypeException {
        MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(type).orElseGet(() -> null);
        if (mm4 == null) {
            throw new InvalidMobTypeException(type + " is not a valid Mythic Mob type.");
        }
        return mm4.spawn(BukkitAdapter.adapt(location), level, SpawnReason.OTHER).getEntity().getBukkitEntity();
    }

    public boolean isMythicMob(Entity l) {
        return MythicBukkit.inst().getMobManager().isActiveMob(BukkitAdapter.adapt(l));
    }

    public boolean isMythicMob(UUID u) {
        return MythicBukkit.inst().getMobManager().isActiveMob(u);
    }

    public ActiveMob getMythicMobInstance(Entity e) {
        return MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e));
    }

    public boolean castSkill(Entity e, String skillName) {
        return this.castSkill(e, skillName, e.getLocation(), 1.0f);
    }

    public boolean castSkill(Entity e, String skillName, Consumer<SkillMetadata> transformer) {
        return this.castSkill(e, skillName, e.getLocation(), 1.0f, transformer);
    }

    public boolean castSkill(Entity e, String skillName, float power) {
        return this.castSkill(e, skillName, e.getLocation(), power);
    }

    public boolean castSkill(Entity e, String skillName, float power, Consumer<SkillMetadata> transformer) {
        return this.castSkill(e, skillName, e.getLocation(), power, transformer);
    }

    public boolean castSkill(Entity e, String skillName, Location origin) {
        return this.castSkill(e, skillName, origin, 1.0f);
    }

    public boolean castSkill(Entity e, String skillName, Location origin, Consumer<SkillMetadata> transformer) {
        return this.castSkill(e, skillName, origin, 1.0f, transformer);
    }

    public boolean castSkill(Entity e, String skillName, Location origin, float power) {
        return this.castSkill(e, skillName, null, origin, null, null, power);
    }

    public boolean castSkill(Entity e, String skillName, Location origin, float power, Consumer<SkillMetadata> transformer) {
        return this.castSkill(e, skillName, null, origin, null, null, power, transformer);
    }

    public boolean castSkill(Entity e, String skillName, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power) {
        return this.castSkill(e, skillName, null, origin, eTargets, lTargets, power);
    }

    public boolean castSkill(Entity e, String skillName, Entity trigger, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power) {
        return this.castSkill(e, skillName, null, origin, eTargets, lTargets, power, null);
    }

    public boolean castSkill(Entity e, String skillName, Entity trigger, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power, Consumer<SkillMetadata> transformer) {
        Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(skillName);
        if (!maybeSkill.isPresent()) {
            return false;
        }
        SkillCaster caster = MythicBukkit.inst().getMobManager().isActiveMob(e.getUniqueId()) ? MythicBukkit.inst().getMobManager().getMythicMobInstance(e) : new GenericCaster(BukkitAdapter.adapt(e));
        Skill skill = maybeSkill.get();
        ArrayList feTargets = Lists.newArrayList();
        ArrayList flTargets = Lists.newArrayList();
        if (eTargets != null) {
            for (Entity en : eTargets) {
                feTargets.add(BukkitAdapter.adapt(en));
            }
        }
        if (lTargets != null) {
            for (Location l : lTargets) {
                flTargets.add(BukkitAdapter.adapt(l));
            }
        }
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.API, caster, BukkitAdapter.adapt(trigger), BukkitAdapter.adapt(origin), feTargets, flTargets, power);
        if (transformer != null) {
            transformer.accept(data);
        }
        if (skill.isUsable(data, SkillTriggers.API)) {
            skill.execute(data);
        }
        return true;
    }

    public boolean addThreat(Entity mob, LivingEntity target, double amount) {
        if (!MythicBukkit.inst().getMobManager().isActiveMob(mob.getUniqueId())) {
            return false;
        }
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(mob);
        if (am.getThreatTable() == null) {
            return false;
        }
        am.getThreatTable().threatGain(BukkitAdapter.adapt((Entity)target), amount);
        return true;
    }

    public boolean reduceThreat(Entity mob, LivingEntity target, double amount) {
        if (!MythicBukkit.inst().getMobManager().isActiveMob(mob.getUniqueId())) {
            return false;
        }
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(mob);
        if (am.getThreatTable() == null) {
            return false;
        }
        am.getThreatTable().threatLoss(BukkitAdapter.adapt((Entity)target), amount);
        return true;
    }

    public boolean taunt(Entity mob, LivingEntity target) {
        if (!MythicBukkit.inst().getMobManager().isActiveMob(mob.getUniqueId())) {
            return false;
        }
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(mob);
        if (am.getThreatTable() == null) {
            return false;
        }
        am.getThreatTable().Taunt(BukkitAdapter.adapt((Entity)target));
        return true;
    }
}

