/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.skills.damage;

import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.entity.EntityDamageEvent;

public class ExtendedDamageMetadata
extends DamageMetadata {
    private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();

    public ExtendedDamageMetadata(SkillCaster damager, double amount, String element, Boolean ignoresArmor, Boolean preventsImmunity, Boolean preventsKnockback, Boolean ignoreEnchantments, EntityDamageEvent.DamageCause damageCause) {
        super(damager, amount, element, ignoresArmor, preventsImmunity, preventsKnockback, ignoreEnchantments, damageCause);
    }

    public void putObject(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getValue(String key) {
        return this.data.get(key);
    }

    public Object getOrDefault(String key, Object def) {
        return this.data.getOrDefault(key, def);
    }

    public void putString(String key, String value) {
        this.data.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.data.put(key, value);
    }

    public void putFloat(String key, float value) {
        this.data.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.data.put(key, value);
    }

    public String getString(String key) {
        return this.data.get(key).toString();
    }

    public boolean getBoolean(String key) {
        Object object = this.getValue(key);
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        return false;
    }

    public float getFloat(String key) {
        Object object = this.getValue(key);
        if (object instanceof Float) {
            Float f = (Float)object;
            return f.floatValue();
        }
        throw new NumberFormatException(this.getString(key) + " is not a decimal value");
    }

    public double getDouble(String key) {
        Object object = this.getValue(key);
        if (object instanceof Double) {
            Double f = (Double)object;
            return f;
        }
        return this.getFloat(key);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DamageMetadata(damager=").append(this.getDamager().getName()).append(", amount=").append(this.getAmount()).append(", element=").append(this.getElement()).append(", ignoresArmor=").append(this.getIgnoresArmor()).append(", preventsImmunity=").append(this.getPreventsImmunity()).append(", preventsKnockback=").append(this.getPreventsKnockback()).append(", ignoreEnchantments=").append(this.getIgnoreEnchantments()).append(", damageCause=").append(this.getDamageCause());
        this.data.forEach((key, value) -> sb.append(", ").append((String)key).append("=").append(value));
        sb.append(")");
        return sb.toString();
    }
}

