/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters;

public abstract class AbstractStructure {
    private final String key;

    public AbstractStructure(String key) {
        this.key = key.toLowerCase();
    }

    public String toString() {
        return this.key;
    }

    public boolean matches(String structure) {
        if (structure.contains("*") || structure.contains("?")) {
            return this.key.matches(structure.replace("?", ".?").replace("*", ".*?"));
        }
        return this.key.equalsIgnoreCase(structure);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractStructure) {
            AbstractStructure biome = (AbstractStructure)o;
            return this.getKey().equals(biome.getKey());
        }
        if (o instanceof String) {
            String string = (String)o;
            return this.getKey().equalsIgnoreCase(string);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String getKey() {
        return this.key;
    }
}

