/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_18_R1.ai.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_18_R1.ai.PathfinderHolder;
import java.util.List;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="nearestConditionalTarget", aliases={"nearestConditional", "nearestIf"}, description="Target a nearby attacker that meets the conditions", premium=true)
public class NearestConditionalTargetGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    protected String targetConditionString;
    protected List<SkillCondition> targetConditions = null;
    protected int interval;

    public NearestConditionalTargetGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.targetConditionString = mlc.getString(new String[]{"targetconditions", "conditions", "cond", "c"}, "null", new String[0]);
        if (this.targetConditionString != null) {
            this.targetConditions = NearestConditionalTargetGoal.getPlugin().getSkillManager().getConditions(this.targetConditionString);
        }
        this.interval = mlc.getInteger(new String[]{"interval", "int", "i"}, 0);
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new PathfinderGoalNearestAttackableTarget((EntityInsentient)PathfinderHolder.getNMSEntity(this.entity), EntityLiving.class, this.interval, true, false, targetEntity -> {
            try {
                AbstractEntity absEntity = BukkitAdapter.adapt((Entity)((EntityLiving)targetEntity).getBukkitEntity());
                for (SkillCondition cond : this.targetConditions) {
                    if (cond.evaluateToEntity(this.entity, absEntity)) continue;
                    return false;
                }
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
            return true;
        });
    }
}

