/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_17_R1;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileAIHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ai.Pathfinder;
import io.lumine.mythic.core.mobs.ai.PathfinderAdapter;
import io.lumine.mythic.core.mobs.ai.WrappedPathfinder;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.utils.reflections.VersionCompliantReflections;
import io.lumine.mythic.core.volatilecode.v1_17_R1.ai.CustomAIAdapter;
import io.lumine.mythic.core.volatilecode.v1_17_R1.ai.PathfinderHolder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityTargetEvent;

public class VolatileAIHandler_v1_17_R1
implements VolatileAIHandler {
    private Reflector<EntityInsentient> refEntityInsentient = new Reflector<EntityInsentient>(EntityInsentient.class, "bP", "bQ");
    private Reflector<PathfinderGoalSelector> refGoalSelector = new Reflector<PathfinderGoalSelector>(PathfinderGoalSelector.class, "c", "d");
    private final Map<String, Class<? extends PathfinderAdapter>> AI_GOALS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();
    private final Map<String, Class<? extends PathfinderAdapter>> AI_TARGETS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();

    public VolatileAIHandler_v1_17_R1(VolatileCodeHandler handler) {
        Set<Class<?>> customGoalClasses = new VersionCompliantReflections("io.lumine.mythic.core.mobs.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : customGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] stringArray = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load custom AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> wrappedGoalClasses = new VersionCompliantReflections("io.lumine.mythic.core.volatilecode.v1_17_R1.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : wrappedGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load wrapped AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set = new VersionCompliantReflections("io.lumine.mythic.core.mobs.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load custom AI targeter {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set2 = new VersionCompliantReflections("io.lumine.mythic.core.volatilecode.v1_17_R1.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set2) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load wrapped AI targeter {0}", clazz.getCanonicalName());
            }
        }
    }

    @Override
    public void setTarget(LivingEntity entity, LivingEntity target) {
        if (entity instanceof Creature) {
            try {
                ((Creature)entity).setTarget(target);
            }
            catch (Exception exception) {}
        } else {
            try {
                ((EntityInsentient)((CraftLivingEntity)entity).getHandle()).setGoalTarget(((CraftLivingEntity)target).getHandle(), EntityTargetEvent.TargetReason.CUSTOM, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void navigateToLocation(AbstractEntity entity, AbstractLocation destination, double speedModifier) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        e.getNavigation().a(destination.getX(), destination.getY(), destination.getZ(), speedModifier);
    }

    public void clearPathfinderGoals(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "bO");
        ((Map)this.refGoalSelector.get(goals, "c")).clear();
        ((Set)this.refGoalSelector.get(goals, "d")).clear();
    }

    public void clearPathfinderTargets(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "bP");
        ((Map)this.refGoalSelector.get(goals, "c")).clear();
        ((Set)this.refGoalSelector.get(goals, "d")).clear();
    }

    public void addPathfindersGoal(int index, AbstractEntity entity, PathfinderGoal goal, Predicate<AbstractEntity> validator) {
        block3: {
            if (validator != null && !validator.test(entity)) {
                return;
            }
            EntityInsentient nmsEntity = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
            PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(nmsEntity, "");
            try {
                goals.a(index, goal);
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to apply pathfinder goal");
                if (ConfigExecutor.debugLevel <= 0) break block3;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addPathfinderGoals(LivingEntity entity, List<String> aiMods) {
        block17: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "bP");
                int i = 0;
                int j = 0;
                block11: for (String str : aiMods) {
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : null;
                        data2 = split.length > 3 ? split[3] : null;
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : null;
                        data2 = split.length > 2 ? split[2] : null;
                    }
                    MythicLineConfigImpl mlc = new MythicLineConfigImpl(MythicLineConfigImpl.unparseBlock(goal));
                    goal = mlc.getKey();
                    if (this.AI_GOALS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_GOALS.get(goal.toUpperCase());
                        try {
                            if (Pathfinder.class.isAssignableFrom(clazz)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc);
                                goals.a(j, CustomAIAdapter.create(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            ((Map)this.refGoalSelector.get(goals, "c")).clear();
                            ((Set)this.refGoalSelector.get(goals, "d")).clear();
                            continue block11;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error occurred while adding an AIGoalSelector, enable debugging for a stack trace.");
                if (ConfigExecutor.debugLevel <= 0) break block17;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addTargetGoals(LivingEntity entity, List<String> aiMods) {
        block17: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "bQ");
                int i = 0;
                int j = 0;
                block11: for (String str : aiMods) {
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : "";
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : "";
                    }
                    MythicLineConfigImpl mlc = new MythicLineConfigImpl(goal);
                    goal = mlc.getKey();
                    if (this.AI_TARGETS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_TARGETS.get(goal.toUpperCase());
                        try {
                            if (clazz.isAssignableFrom(Pathfinder.class)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc);
                                goals.a(j, CustomAIAdapter.create(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            ((Map)this.refGoalSelector.get(goals, "c")).clear();
                            ((Set)this.refGoalSelector.get(goals, "d")).clear();
                            e.setGoalTarget(null);
                            continue block11;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error has occurred, enable debugging for a stack trace.");
                if (ConfigExecutor.debugLevel <= 0) break block17;
                ex.printStackTrace();
            }
        }
    }
}

