/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3.ai.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_16_R3.ai.PathfinderHolder;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityCreature;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.PathfinderGoal;
import net.minecraft.server.v1_16_R3.PathfinderGoalNearestAttackableTarget;

@MythicAIGoal(name="nearestOtherFaction", aliases={"otherFaction"}, description="Target a nearby entity that is in a different faction")
public class OtherFactionGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    public OtherFactionGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        EntityInsentient e = PathfinderHolder.getNMSEntity(this.entity);
        return new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityLiving.class, 0, true, false, targetEntity -> {
            try {
                ActiveMob mob = OtherFactionGoal.getPlugin().getMobManager().getMythicMobInstance(this.getEntity());
                AbstractEntity target = BukkitAdapter.adapt((org.bukkit.entity.Entity)((Entity)targetEntity).getBukkitEntity());
                if (mob == null || !mob.hasFaction()) {
                    return true;
                }
                if (target.isPlayer()) {
                    return !OtherFactionGoal.getPlugin().getPlayerManager().getFactionProvider().isInFaction(target.asPlayer(), mob.getFaction());
                }
                Optional<ActiveMob> maybeTargetAM = OtherFactionGoal.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
                if (!maybeTargetAM.isPresent()) {
                    return true;
                }
                ActiveMob targetAM = maybeTargetAM.get();
                if (targetAM.hasFaction()) {
                    return !mob.getFaction().equals(targetAM.getFaction());
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        });
    }
}

