/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileAIHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileBlockHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileItemHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileWorldHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.utils.VectorUtils;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.volatilecode.v1_17_R1.CompoundTag_v1_17_R1;
import io.lumine.mythic.core.volatilecode.v1_17_R1.VolatileAIHandler_v1_17_R1;
import io.lumine.mythic.core.volatilecode.v1_17_R1.VolatileBlockHandler_v1_17_R1;
import io.lumine.mythic.core.volatilecode.v1_17_R1.VolatileEntityHandler_v1_17_R1;
import io.lumine.mythic.core.volatilecode.v1_17_R1.VolatileItemHandler_v1_17_R1;
import io.lumine.mythic.core.volatilecode.v1_17_R1.VolatileWorldHandler_v1_17_R1;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class VolatileCodeEnabled_v1_17_R1
implements VolatileCodeHandler {
    private final VolatileAIHandler AIHandler = new VolatileAIHandler_v1_17_R1(this);
    private final VolatileBlockHandler blockHandler = new VolatileBlockHandler_v1_17_R1(this);
    private final VolatileEntityHandler entityHandler = new VolatileEntityHandler_v1_17_R1(this);
    private final VolatileItemHandler itemHandler = new VolatileItemHandler_v1_17_R1(this);
    private final VolatileWorldHandler worldHandler = new VolatileWorldHandler_v1_17_R1(this);
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.BAT, new EntityType[]{EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.HORSE, EntityType.MAGMA_CUBE, EntityType.POLAR_BEAR, EntityType.SILVERFISH, EntityType.SLIME});

    @Override
    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTag_v1_17_R1(value);
    }

    @Override
    public Set<AbstractEntity> getEntitiesBySelector(SkillCaster am, String targetSelector) {
        return null;
    }

    @Override
    public void CreateFireworksExplosion(Location location, boolean flicker, boolean trail, int type, int[] colors, int[] fadeColors, int flightDuration) {
    }

    @Override
    public void setChickenHostile(Chicken c) {
        EntityChicken chicken = ((CraftChicken)c).getHandle();
        chicken.setAggressive(true);
    }

    @Override
    public void doDamage(ActiveMob mob, AbstractEntity t2, float amount) {
        CraftLivingEntity caster = (CraftLivingEntity)mob.getEntity().getBukkitEntity();
        CraftLivingEntity target = (CraftLivingEntity)t2.getBukkitEntity();
        target.getHandle().damageEntity(DamageSource.mobAttack((EntityLiving)caster.getHandle()), amount);
    }

    @Override
    public double getAbsorptionHearts(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().getAbsorptionHearts();
    }

    @Override
    public void saveSkinData(Player player, String name) {
        block3: {
            GameProfile profile = ((CraftPlayer)player).getHandle().getProfile();
            Collection props = profile.getProperties().get((Object)"textures");
            Iterator iterator = props.iterator();
            if (!iterator.hasNext()) break block3;
            Property prop = (Property)iterator.next();
            String skin = prop.getValue();
            String sig = prop.getSignature();
            File folder = new File(MythicBukkit.inst().getDataFolder(), "PlayerSkins");
            if (!folder.exists()) {
                folder.mkdir();
            }
            File skinFile = new File(folder, name + ".skin.txt");
            File sigFile = new File(folder, name + ".sig.txt");
            try {
                FileWriter writer = new FileWriter(skinFile);
                writer.write(skin);
                writer.flush();
                writer.close();
                writer = new FileWriter(sigFile);
                writer.write(sig);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public float getItemRecharge(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.getAttackCooldown(0.0f);
    }

    @Override
    public boolean getItemRecharging(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.getAttackCooldown(0.0f) < 1.0f;
    }

    @Override
    public void doEffectArmSwing(AbstractEntity entity) {
        Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.getWorld().broadcastEntityEffect(e, (byte)0);
    }

    @Override
    public void lookAt(AbstractEntity entity, float yaw, float pitch) {
        Entity handle = ((CraftEntity)BukkitAdapter.adapt(entity)).getHandle();
        yaw = VectorUtils.clampYaw(yaw);
        handle.setXRot(yaw);
        this.setHeadYaw(entity, yaw);
        handle.setHeadRotation(pitch);
    }

    @Override
    public void lookAtLocation(AbstractEntity entity, AbstractLocation to, boolean headOnly, boolean immediate) {
        Entity handle = ((CraftEntity)BukkitAdapter.adapt(entity)).getHandle();
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient)) {
            AbstractLocation fromLocation = entity.getLocation();
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - 90.0;
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw -= 90.0;
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.lookAt(entity, (float)yaw, (float)pitch);
            }
        } else {
            ((EntityInsentient)handle).getControllerLook().a(to.getX(), to.getY(), to.getZ());
        }
    }

    @Override
    public void lookAtEntity(AbstractEntity entity, AbstractEntity to, boolean headOnly, boolean immediate) {
        Entity handle = ((CraftEntity)BukkitAdapter.adapt(entity)).getHandle();
        Entity target = ((CraftEntity)BukkitAdapter.adapt(to)).getHandle();
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType())) {
            if (to.isLiving()) {
                this.lookAtLocation(entity, to.getEyeLocation(), headOnly, immediate);
            } else {
                this.lookAtLocation(entity, to.getLocation(), headOnly, immediate);
            }
        } else if (handle instanceof EntityInsentient) {
            EntityInsentient insentient = (EntityInsentient)handle;
            insentient.getControllerLook().a(target);
        }
    }

    @Override
    public void sendResourcePack(AbstractPlayer player, String url, String hash) {
        Player p = (Player)player.getBukkitEntity();
        p.setResourcePack(url, hash);
    }

    @Override
    public void applyPhysics(org.bukkit.block.Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        Block block = iblockdata.getBlock();
        world.update(blockposition, block);
    }

    @Override
    public VolatileAIHandler getAIHandler() {
        return this.AIHandler;
    }

    @Override
    public VolatileBlockHandler getBlockHandler() {
        return this.blockHandler;
    }

    @Override
    public VolatileEntityHandler getEntityHandler() {
        return this.entityHandler;
    }

    @Override
    public VolatileItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public VolatileWorldHandler getWorldHandler() {
        return this.worldHandler;
    }
}

