/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.spawning.random.RandomSpawnGenerator;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import io.lumine.mythic.core.spawning.random.RandomSpawnerAction;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawnerManager
extends ReloadableModule<MythicBukkit> {
    private List<File> spawnFiles;
    private IOLoader<MythicBukkit> defaultSpawns;
    private List<IOLoader<MythicBukkit>> spawnLoaders;
    public List<RandomSpawner> listRandomSpawningAddLand = Lists.newArrayList();
    public List<RandomSpawner> listRandomSpawningAddSea = Lists.newArrayList();
    public List<RandomSpawner> listRandomSpawningAddLava = Lists.newArrayList();
    public List<RandomSpawner> listRandomSpawningAddAir = Lists.newArrayList();
    public List<RandomSpawner> listRandomSpawningR = Lists.newArrayList();
    public List<RandomSpawner> listRandomSpawningD = Lists.newArrayList();
    public Set<RandomSpawnPoint> landSpawnPoints = Sets.newConcurrentHashSet();
    public Set<RandomSpawnPoint> airSpawnPoints = Sets.newConcurrentHashSet();
    public Set<RandomSpawnPoint> seaSpawnPoints = Sets.newConcurrentHashSet();
    public Set<RandomSpawnPoint> lavaSpawnPoints = Sets.newConcurrentHashSet();
    public Set<RandomSpawnPoint> groundSpawnPoints = Sets.newConcurrentHashSet();
    public Set<ActiveMob> randomlySpawnedMobs = Sets.newConcurrentHashSet();
    RandomPointGeneratorLand spawnPointGenerator;

    public RandomSpawnerManager(MythicBukkit core) {
        super(core);
    }

    public void loadRandomSpawns() {
        MythicLogger.log("Loading Random Spawns...");
        this.defaultSpawns = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleRandomSpawns.yml", "RandomSpawns");
        this.spawnFiles = IOHandler.getAllFiles(this.defaultSpawns.getFile().getParent());
        File packsFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "RandomSpawns")).exists() || !confFolder.isDirectory()) continue;
                this.spawnFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        this.spawnLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), this.spawnFiles, "RandomSpawns");
        this.listRandomSpawningAddLand.clear();
        this.listRandomSpawningAddSea.clear();
        this.listRandomSpawningAddLava.clear();
        this.listRandomSpawningAddAir.clear();
        this.listRandomSpawningR.clear();
        this.listRandomSpawningD.clear();
        for (IOLoader iOLoader : this.spawnLoaders) {
            for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfigImpl mc = new MythicConfigImpl(name, iOLoader.getCustomConfig());
                String file = iOLoader.getFile().getName();
                try {
                    RandomSpawner rs = new RandomSpawner(this, file, name, mc);
                    if (rs.getAction() == RandomSpawnerAction.ADD) {
                        switch (rs.getPositionType()) {
                            case AIR: {
                                this.listRandomSpawningAddAir.add(rs);
                                break;
                            }
                            case GROUND: {
                                break;
                            }
                            case LAND: {
                                this.listRandomSpawningAddLand.add(rs);
                                break;
                            }
                            case LAVA: {
                                this.listRandomSpawningAddLava.add(rs);
                                break;
                            }
                            case SEA: {
                                this.listRandomSpawningAddSea.add(rs);
                            }
                        }
                        continue;
                    }
                    if (rs.getAction() == RandomSpawnerAction.DENY) {
                        this.listRandomSpawningD.add(rs);
                        continue;
                    }
                    this.listRandomSpawningR.add(rs);
                }
                catch (Error | Exception ex) {
                    MythicLogger.error("Failed to load RandomSpawner {0} in file {1} - invalid configuration", name, file);
                    ex.printStackTrace();
                }
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Sorting ADD Random Spawners...", new Object[0]);
        this.listRandomSpawningAddLand = this.sortSpawners(this.listRandomSpawningAddLand);
        this.listRandomSpawningAddSea = this.sortSpawners(this.listRandomSpawningAddSea);
        this.listRandomSpawningAddAir = this.sortSpawners(this.listRandomSpawningAddAir);
        this.listRandomSpawningAddLava = this.sortSpawners(this.listRandomSpawningAddLava);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Sorting REPLACE Random Spawners...", new Object[0]);
        this.listRandomSpawningR = this.sortSpawners(this.listRandomSpawningR);
        if (ConfigExecutor.generateRSPoints()) {
            if (this.spawnPointGenerator == null && ConfigExecutor.getRSPointsPerSecondLand() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Starting up SpawnPointGenerator!", new Object[0]);
                this.spawnPointGenerator = new RandomPointGeneratorLand();
            }
        } else if (this.spawnPointGenerator != null) {
            this.spawnPointGenerator.stop();
            this.spawnPointGenerator = null;
        }
    }

    public int getNumberOfSpawners() {
        return this.listRandomSpawningAddLand.size() + this.listRandomSpawningAddSea.size() + this.listRandomSpawningAddAir.size() + this.listRandomSpawningR.size() + this.listRandomSpawningD.size();
    }

    public AbstractEntity handleSpawnEvent(RandomSpawnPoint rsp) {
        if (rsp.getReason() == CreatureSpawnEvent.SpawnReason.NATURAL && BukkitEntityType.getIsSpawning().booleanValue()) {
            return null;
        }
        if (rsp.getEntity() == null) {
            return null;
        }
        if (this.listRandomSpawningR.size() == 0) {
            return null;
        }
        if (!ConfigExecutor.generateRSPoints()) {
            this.landSpawnPoints.add(rsp);
        }
        for (RandomSpawner RS : this.listRandomSpawningR) {
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            ActiveMob mob = RS.spawn(rsp);
            return mob != null ? mob.getEntity() : null;
        }
        return null;
    }

    @Override
    public void load(MythicBukkit plugin) {
        if (ConfigExecutor.generateRSPoints() && ConfigExecutor.getRSPointsPerSecondLand() > 0) {
            this.spawnPointGenerator = new RandomPointGeneratorLand();
        }
    }

    @Override
    public void unload() {
        if (this.spawnPointGenerator != null) {
            this.spawnPointGenerator.stop();
        }
    }

    public void spawnMobs() {
        this.landSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp, this.listRandomSpawningAddLand.iterator()));
        this.landSpawnPoints.clear();
        this.seaSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp, this.listRandomSpawningAddSea.iterator()));
        this.seaSpawnPoints.clear();
        this.lavaSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp, this.listRandomSpawningAddLava.iterator()));
        this.lavaSpawnPoints.clear();
    }

    public void doSpawns(RandomSpawnPoint rsp, Iterator<RandomSpawner> it) {
        if (rsp == null) {
            return;
        }
        while (it.hasNext()) {
            RandomSpawner RS = it.next();
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            RS.spawn(rsp);
            return;
        }
    }

    public int getMobsNearPlayer(AbstractPlayer p) {
        int i = 0;
        int spawnRadius = (int)Math.pow(ConfigExecutor.getRSPlayerRadius(), 2.0);
        for (AbstractEntity e : MythicBukkit.inst().getEntityManager().getLivingEntities(p.getLocation().getWorld())) {
            if (!(e.getLocation().distanceSquared(p.getLocation()) <= (double)spawnRadius)) continue;
            ++i;
        }
        return i;
    }

    public Set<RandomSpawnPoint> getLandSpawnPoints() {
        return this.landSpawnPoints;
    }

    public Set<RandomSpawnPoint> getSeaSpawnPoints() {
        return this.seaSpawnPoints;
    }

    private List<RandomSpawner> sortSpawners(List<RandomSpawner> list) {
        int i;
        for (i = 0; i < list.size(); ++i) {
            for (int q = 1; q < list.size() - i; ++q) {
                RandomSpawner o = list.get(q - 1);
                RandomSpawner n = list.get(q);
                if (o.getPriority() >= n.getPriority()) continue;
                list.set(q - 1, n);
                list.set(q, o);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Random Spawns Sorted to:", new Object[0]);
        for (i = 0; i < list.size(); ++i) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "* " + list.get(i).getPriority() + " = " + list.get(i).getName(), new Object[0]);
        }
        return list;
    }

    public class RandomPointGeneratorLand
    extends RandomSpawnGenerator {
        @Override
        public void generateSpawnPoints() {
            if (MythicBukkit.inst().getEntityManager().getPlayers().size() <= 0) {
                return;
            }
            MythicBukkit.inst().getTimingsHandler().markRandomGeneratorsNew();
            long startTime = System.currentTimeMillis();
            ArrayList<AbstractPlayer> players = new ArrayList<AbstractPlayer>();
            players.addAll(((MythicBukkit)RandomSpawnerManager.this.getPlugin()).getEntityManager().getPlayers());
            Collections.shuffle(players);
            int n = 0;
            int spawnRadius = ConfigExecutor.getRSPlayerRadius();
            int spawnRadiusY = ConfigExecutor.getRSPlayerRadiusY();
            int minRadiusSquared = 256;
            Iterator itp = players.iterator();
            try {
                while (itp.hasNext()) {
                    AbstractPlayer player = (AbstractPlayer)itp.next();
                    if (player == null || player.isInCreativeMode()) continue;
                    if (System.currentTimeMillis() - startTime > (long)ConfigExecutor.getRSMaxGenerationTimeMillis()) break;
                    int bucketLand = ConfigExecutor.getRSPointsPerSecondLand();
                    int bucketSea = ConfigExecutor.getRSPointsPerSecondSea();
                    int bucketAir = ConfigExecutor.getRSPointsPerSecondAir();
                    int bucketLava = ConfigExecutor.getRSPointsPerSecondLava();
                    int totalBucket = bucketLand + bucketSea + bucketAir + bucketLava;
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Generating RandomSpawnPoints near Player {0}", player.getName());
                    while (totalBucket > 0 && System.currentTimeMillis() - startTime <= (long)ConfigExecutor.getRSMaxGenerationTimeMillis()) {
                        RandomSpawnPoint point;
                        Location location = BukkitAdapter.adapt(player.getLocation());
                        Location spawnLocation = new Location(location.getWorld(), 0.0, 0.0, 0.0);
                        int nx = (int)(location.getX() - (double)spawnRadius) + Numbers.randomInt(spawnRadius * 2);
                        int nz = (int)(location.getZ() - (double)spawnRadius) + Numbers.randomInt(spawnRadius * 2);
                        int ny = (int)(location.getY() - (double)spawnRadiusY) + Numbers.randomInt(spawnRadiusY * 2);
                        spawnLocation.setX((double)nx);
                        spawnLocation.setY((double)ny);
                        spawnLocation.setZ((double)nz);
                        if (!player.getWorld().isChunkLoaded(spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4)) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Skipping player, area chunks not loaded.", new Object[0]);
                            --totalBucket;
                            continue;
                        }
                        int mobsInChunk = 0;
                        try {
                            mobsInChunk = player.getWorld().getEntitiesInChunk(spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (mobsInChunk >= ConfigExecutor.getRSMaxMobsPerChunk()) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Too many entities in chunk, skipping", new Object[0]);
                            --totalBucket;
                            continue;
                        }
                        if (spawnLocation.distanceSquared(location) < 256.0) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Distance too far, skipping", new Object[0]);
                            continue;
                        }
                        if (spawnLocation.getBlock().isLiquid()) {
                            if (spawnLocation.getBlock().getType() == Material.WATER) {
                                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Found water. Adding Sea point", new Object[0]);
                                returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny, (double)nz + 0.5);
                                point = new RandomSpawnPoint(returnLocation, SpawnPointType.SEA);
                            } else {
                                if (spawnLocation.getBlock().getType() != Material.LAVA) continue;
                                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Found lava. Adding Lava point", new Object[0]);
                                returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny, (double)nz + 0.5);
                                point = new RandomSpawnPoint(returnLocation, SpawnPointType.LAVA);
                            }
                        } else {
                            boolean goodd;
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Adding Land point", new Object[0]);
                            if (!spawnLocation.getBlock().getType().isSolid()) {
                                goodd = false;
                                for (int j = 0; j < spawnRadiusY * 2; ++j) {
                                    spawnLocation.setY((double)(--ny));
                                    if (spawnLocation.getBlock().getType() == Material.WATER) break;
                                    if (!spawnLocation.getBlock().getType().isSolid()) continue;
                                    goodd = true;
                                    break;
                                }
                                if (!goodd) continue;
                            }
                            goodd = true;
                            for (int k = 1; k < 3; ++k) {
                                spawnLocation.setY(spawnLocation.getY() + 1.0);
                                if (!spawnLocation.getBlock().getType().isSolid()) continue;
                                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! {0} is NOT pathable, skipping", spawnLocation.getBlock().getType().toString());
                                goodd = false;
                                break;
                            }
                            if (!goodd) {
                                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Couldn't find land position this time", new Object[0]);
                                continue;
                            }
                            returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny + 1, (double)nz + 0.5);
                            point = new RandomSpawnPoint(returnLocation, SpawnPointType.LAND);
                        }
                        if (point == null) continue;
                        Iterator<RandomSpawner> it = RandomSpawnerManager.this.listRandomSpawningD.iterator();
                        boolean good = true;
                        while (it.hasNext()) {
                            RandomSpawner RS = it.next();
                            if (!RS.checkSpawn(point)) continue;
                            good = false;
                            break;
                        }
                        if (good) {
                            if (point.getPointType() == SpawnPointType.LAND && bucketLand > 0) {
                                RandomSpawnerManager.this.landSpawnPoints.add(point);
                                --bucketLand;
                                ++n;
                            } else if (point.getPointType() == SpawnPointType.SEA && bucketSea > 0) {
                                RandomSpawnerManager.this.seaSpawnPoints.add(point);
                                --bucketSea;
                                ++n;
                            } else if (point.getPointType() == SpawnPointType.LAVA && bucketSea > 0) {
                                RandomSpawnerManager.this.lavaSpawnPoints.add(point);
                                --bucketLava;
                                ++n;
                            }
                            --totalBucket;
                        } else {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Skipped spawn point due to DENY action", new Object[0]);
                        }
                        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "++ Generated Random Point at {0}", point.getLocation().toString());
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Generated Points: {0}", n);
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Land {0} Sea {1} Lava {2}", bucketLand, bucketSea, bucketLava);
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Time taken: {0}", System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MythicBukkit.inst().getTimingsHandler().markRandomGeneratorsComplete();
        }

        @Override
        public RandomSpawnPoint findPointNearPlayer(AbstractPlayer player, boolean searchLand) {
            return null;
        }
    }
}

