/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.core.skills.variables.Variable;

public class FloatVariable
extends Variable {
    private float value;

    public FloatVariable(float value) {
        Preconditions.checkNotNull(Float.valueOf(value));
        this.value = value;
    }

    public FloatVariable(float value, long expirationTime) {
        super(expirationTime);
        Preconditions.checkNotNull(Float.valueOf(value));
        this.value = value;
    }

    @Override
    public Object get() {
        return Float.valueOf(this.value);
    }

    public String toString() {
        return "" + this.value;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatVariable)) {
            return false;
        }
        FloatVariable other = (FloatVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FloatVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getValue());
        return result;
    }
}

