/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableManager;
import io.lumine.mythic.core.skills.variables.VariableScope;

public class VariableMechanic
extends SkillMechanic {
    protected String key;
    protected VariableScope scope;
    protected long duration;

    public VariableMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.key = mlc.getString(new String[]{"name", "n", "variable", "var", "key", "k"}, null, new String[0]);
        if (this.key == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "Variable name must be set.");
            return;
        }
        String prefixVar = VariableScope.SKILL.toString();
        if (this.key.contains(".")) {
            String[] split = this.key.split("\\.");
            prefixVar = split[0].toUpperCase();
            this.key = split[1];
        }
        String strScope = mlc.getString(new String[]{"scope", "s"}, prefixVar, new String[0]);
        try {
            this.scope = VariableScope.valueOf(strScope.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + strScope + "' is not a valid variable scope.");
        }
        boolean shouldSave = mlc.getBoolean("save", false);
        long duration = mlc.getLong(new String[]{"duration", "d", "expire", "e"}, 0L);
        this.duration = duration == 0L ? (shouldSave ? 0L : 1L) : System.currentTimeMillis() + duration * 50L;
    }

    public VariableManager getVariableManager() {
        return ((MythicBukkit)this.getPlugin()).getVariableManager();
    }

    protected void handleDuration(Variable var) {
    }
}

