/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="livingInCone", aliases={"entitiesInCone", "livingEntitiesInCone", "LEIC", "EIC"}, description="Targets random points in a cone shape")
public class LivingInConeTargeter
extends IEntitySelector {
    protected double angle;
    protected double range;
    protected double rotation;

    public LivingInConeTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.angle = mlc.getDouble(new String[]{"angle", "a"}, 90.0);
        this.range = mlc.getDouble(new String[]{"range", "r"}, 16.0);
        this.rotation = mlc.getDouble(new String[]{"rotation", "rot"}, 0.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> possible = new HashSet<AbstractEntity>();
        for (AbstractEntity p : MythicBukkit.inst().getEntityManager().getLivingEntities(am.getEntity().getWorld())) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || p.getUniqueId().equals(am.getEntity().getUniqueId()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.range, 2.0))) continue;
            possible.add(p);
        }
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        AbstractVector dir = data.getCaster().getLocation().getDirection();
        if (this.rotation > 0.0) {
            dir.rotate((float)this.rotation);
        }
        dir.setY(0);
        double cos = Math.cos(this.angle * Math.PI / 180.0);
        double cosSq = cos * cos;
        possible.forEach(entity -> {
            AbstractVector relative = entity.getLocation().subtract(data.getCaster().getLocation()).toVector();
            relative.setY(0);
            double dot = relative.getX() * dir.getX() + relative.getY() * dir.getY() + relative.getZ() * dir.getZ();
            double value = dot * dot / relative.lengthSquared();
            if (this.angle < 180.0 && dot > 0.0 && value >= cosSq) {
                targets.add((AbstractEntity)entity);
            } else if (this.angle >= 180.0 && (dot > 0.0 || dot <= cosSq)) {
                targets.add((AbstractEntity)entity);
            }
        });
        return targets;
    }
}

