/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.targeters.ILocationTargeter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.utils.MythicUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public abstract class ILocationSelector
extends SkillTargeter
implements ILocationTargeter {
    protected PlaceholderDouble xoffset;
    protected PlaceholderDouble yoffset;
    protected PlaceholderDouble zoffset;
    protected PlaceholderDouble forwardOffset;
    protected PlaceholderDouble sideOffset;
    protected PlaceholderDouble rotateX;
    protected PlaceholderDouble rotateY;
    protected PlaceholderDouble rotateZ;
    protected PlaceholderDouble length;
    protected PlaceholderDouble coordinateX;
    protected PlaceholderDouble coordinateY;
    protected PlaceholderDouble coordinateZ;
    protected boolean statics = false;
    protected boolean offsets = false;
    protected boolean advOffset = false;
    protected boolean rotated = false;
    private int limit = 0;
    private FilterSorter sorter = FilterSorter.NONE;

    public ILocationSelector(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.xoffset = mlc.getPlaceholderDouble(new String[]{"xoffset", "xo", "x"}, 0.0, new String[0]);
        this.yoffset = mlc.getPlaceholderDouble(new String[]{"yoffset", "yo", "y"}, 0.0, new String[0]);
        this.zoffset = mlc.getPlaceholderDouble(new String[]{"zoffset", "zo", "z"}, 0.0, new String[0]);
        this.forwardOffset = mlc.getPlaceholderDouble(new String[]{"forwardoffset", "foffset", "fo"}, 0.0, new String[0]);
        this.sideOffset = mlc.getPlaceholderDouble(new String[]{"sideoffset", "soffset", "so"}, 0.0, new String[0]);
        this.rotateX = mlc.getPlaceholderDouble(new String[]{"rotatex", "rotx"}, 0.0, new String[0]);
        this.rotateY = mlc.getPlaceholderDouble(new String[]{"rotatey", "roty"}, 0.0, new String[0]);
        this.rotateZ = mlc.getPlaceholderDouble(new String[]{"rotatez", "rotz"}, 0.0, new String[0]);
        this.length = mlc.getPlaceholderDouble(new String[]{"length"}, 0.0, new String[0]);
        this.coordinateX = mlc.getPlaceholderDouble(new String[]{"coordinatex", "cx"}, 0.0, new String[0]);
        this.coordinateY = mlc.getPlaceholderDouble(new String[]{"coordinatey", "cy"}, 0.0, new String[0]);
        this.coordinateZ = mlc.getPlaceholderDouble(new String[]{"coordinatez", "cz"}, 0.0, new String[0]);
        if (!(this.xoffset.isStaticallyEqualTo(0.0) && this.yoffset.isStaticallyEqualTo(0.0) && this.zoffset.isStaticallyEqualTo(0.0))) {
            this.offsets = true;
        }
        if (!this.forwardOffset.isStaticallyEqualTo(0.0) || !this.sideOffset.isStaticallyEqualTo(0.0)) {
            this.advOffset = true;
        }
        if (!(this.rotateX.isStaticallyEqualTo(0.0) && this.rotateY.isStaticallyEqualTo(0.0) && this.rotateZ.isStaticallyEqualTo(0.0))) {
            this.rotated = true;
        }
        if (!(this.coordinateX.isStaticallyEqualTo(0.0) && this.coordinateY.isStaticallyEqualTo(0.0) && this.coordinateZ.isStaticallyEqualTo(0.0))) {
            this.statics = true;
        }
        this.limit = mlc.getInteger(new String[]{"limit"}, 0);
        String sort = mlc.getString(new String[]{"sort", "sortby"}, "NONE", new String[0]).toUpperCase();
        try {
            this.sorter = FilterSorter.valueOf(sort);
        }
        catch (Exception ex) {
            MythicLogger.errorTargeterConfig(this, mlc, "'" + sort + "' is not a valid sorter.");
        }
    }

    @Override
    public abstract Collection<AbstractLocation> getLocations(SkillMetadata var1);

    public void filter(SkillMetadata data) {
        if (this.targetConditions != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying target conditions", new Object[0]);
            for (SkillCondition mc : this.targetConditions) {
                if (mc.evaluateTargets(data)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying location target filters", new Object[0]);
        Collection targets = data.getLocationTargets();
        if (targets == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ No targets to filter?", new Object[0]);
            return;
        }
        if (this.limit > 0) {
            switch (this.sorter) {
                case NEAREST: {
                    AbstractLocation origin = data.getOrigin();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared((AbstractLocation)o1);
                        double d2 = origin.distanceSquared((AbstractLocation)o2);
                        return Double.compare(d1, d2);
                    }).limit(this.limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case FURTHEST: {
                    AbstractLocation origin = data.getOrigin();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared((AbstractLocation)o1);
                        double d2 = origin.distanceSquared((AbstractLocation)o2);
                        return Double.compare(d2, d1);
                    }).limit(this.limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                case RANDOM: {
                    targets = targets.stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                        Collections.shuffle(collected);
                        return collected.stream();
                    })).limit(this.limit).collect(Collectors.toCollection(ArrayList::new));
                    break;
                }
                default: {
                    targets = targets.stream().limit(this.limit).collect(Collectors.toCollection(ArrayList::new));
                }
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Returning {0} targets", targets.size());
    }

    public AbstractLocation mutate(SkillMetadata data, AbstractLocation location) {
        double len;
        if (this.offsets) {
            location = location.clone().add(this.xoffset.get(data), this.yoffset.get(data), this.zoffset.get(data));
        }
        if (this.advOffset) {
            location = MythicUtil.move(location, this.forwardOffset.get(data), 0.0, this.sideOffset.get(data));
        }
        if ((len = this.length.get(data)) != 0.0) {
            location = location.add(location.getDirection().clone().multiply(len));
        }
        if (this.statics) {
            double cZ;
            double cY;
            double cX = this.coordinateX.get(data);
            if (cX != 0.0) {
                location.setX(cX);
            }
            if ((cY = this.coordinateY.get(data)) != 0.0) {
                location.setX(cY);
            }
            if ((cZ = this.coordinateZ.get(data)) != 0.0) {
                location.setX(cZ);
            }
        }
        return location;
    }

    private static enum FilterSorter {
        NONE,
        RANDOM,
        NEAREST,
        FURTHEST;

    }
}

