/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="forward", aliases={}, description="Targets a point in front of the caster")
public class ForwardTargeter
extends ILocationSelector {
    protected double forward;
    protected float rotate;
    protected boolean useEyeLocation;
    protected boolean lockPitch;
    protected boolean rotated = false;

    public ForwardTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.forward = mlc.getDouble(new String[]{"forward", "f", "amount", "a"}, 5.0);
        this.rotate = mlc.getFloat(new String[]{"rotate", "rot"}, 0.0f);
        this.useEyeLocation = mlc.getBoolean(new String[]{"useeyelocation", "uel"}, false);
        this.lockPitch = mlc.getBoolean(new String[]{"lockpitch"}, false);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        ArrayList<AbstractLocation> targets = Lists.newArrayList();
        AbstractLocation location = this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation();
        if (this.lockPitch) {
            location.setPitch(0.0f);
        }
        if (this.rotate != 0.0f) {
            location.add(location.getDirection().rotate(this.rotate).normalize().multiply(this.forward));
        } else {
            location.add(location.getDirection().normalize().multiply(this.forward));
        }
        targets.add(this.mutate(data, location));
        return targets;
    }
}

