/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Material;

@MythicTargeter(author="Ashijin", name="blocksinradius", aliases={}, description="Targets all blocks in the radius of the inherited target")
public class BlocksInRadiusTargeter
extends ILocationSelector {
    protected PlaceholderDouble radius;
    protected PlaceholderDouble radiusY;
    protected float noise;
    protected double randomness;
    protected boolean sphere = false;
    protected boolean origin = false;
    private MaskType maskType;

    public BlocksInRadiusTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        String radius = mlc.getString(new String[]{"radius", "r"}, "2", new String[0]);
        this.radius = PlaceholderDouble.of(radius);
        this.radiusY = PlaceholderDouble.of(mlc.getString(new String[]{"radiusy", "ry", "yradius", "yr"}, radius, new String[0]));
        this.randomness = mlc.getDouble(new String[]{"noise", "n"}, 0.0);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        boolean noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        boolean onlyAir = mlc.getBoolean(new String[]{"onlyair", "oa"}, false);
        this.origin = mlc.getBoolean(new String[]{"nearorigin", "no"}, false);
        this.maskType = noAir && !onlyAir ? MaskType.IGNORE_AIR : (onlyAir ? MaskType.ONLY_AIR : MaskType.ALL);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter", new Object[0]);
        if (this.origin) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter from Origin", new Object[0]);
            for (AbstractLocation location : this.getBlocksInRadius(data, data.getOrigin())) {
                targets.add(location);
            }
        } else if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter from Entities", new Object[0]);
            for (AbstractEntity e : data.getEntityTargets()) {
                AbstractLocation l = e.getLocation();
                for (AbstractLocation location : this.getBlocksInRadius(data, l)) {
                    targets.add(location);
                }
            }
        } else if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius targeter from Locations", new Object[0]);
            for (AbstractLocation l : data.getLocationTargets()) {
                for (AbstractLocation location : this.getBlocksInRadius(data, l)) {
                    targets.add(location);
                }
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInRadius has no inherited targets", new Object[0]);
        }
        return targets;
    }

    private List<AbstractLocation> getBlocksInRadius(SkillMetadata data, AbstractLocation origin) {
        ArrayList<AbstractLocation> blocks = new ArrayList<AbstractLocation>();
        double radius = this.radius.get(data);
        double radiusSq = (int)Math.pow(radius, 2.0);
        double radiusY = this.radiusY.get(data);
        double radiusSqY = (int)Math.pow(radiusY, 2.0);
        for (double x = -radius; x <= radius; x += 1.0) {
            for (double y = -radiusY; y <= radiusY; y += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    AbstractLocation newloc = new AbstractLocation(origin.getWorld(), origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                    if (this.sphere && origin.distanceSquared(newloc) > radiusSq || this.randomness > 0.0 && this.randomness < Numbers.randomDouble()) continue;
                    if (this.maskType == MaskType.ALL) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType == MaskType.IGNORE_AIR && BukkitAdapter.adapt(newloc).getBlock().getType() != Material.AIR) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType != MaskType.ONLY_AIR || BukkitAdapter.adapt(newloc).getBlock().getType() != Material.AIR) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }

    private static enum MaskType {
        ALL,
        IGNORE_AIR,
        ONLY_AIR;

    }
}

