/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles;

import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.ModelEngineSupport;
import io.lumine.mythic.bukkit.events.MythicProjectileHitEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public abstract class Projectile
extends SkillMechanic {
    public static final Set<AbstractEntity> BULLET_ENTITIES = ConcurrentHashMap.newKeySet();
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onBounceSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected Optional<Skill> onStartSkill = Optional.empty();
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onBounceSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected ProjectileType type;
    protected boolean fromOrigin;
    protected BulletType bulletType;
    protected Material bulletMaterial = null;
    protected int bulletModelId = 0;
    protected MythicItem bulletMythicItem = null;
    protected Projectile bulletProjectile = null;
    protected MythicMob bulletMob = null;
    protected String bulletColor = null;
    protected float bulletSpin = 0.0f;
    protected boolean bulletMatchDirection = false;
    protected PlaceholderInt duration;
    protected int tickInterval;
    protected float ticksPerSecond;
    protected PlaceholderFloat hitRadius;
    protected float verticalHitRadius;
    protected float maxDistanceSquared;
    protected PlaceholderInt deathDelay;
    protected PlaceholderDouble startYOffset;
    protected PlaceholderFloat startForwardOffset;
    protected PlaceholderDouble startSideOffset;
    protected PlaceholderDouble endSideOffset;
    protected PlaceholderDouble targetYOffset;
    protected Optional<SkillTargeter> projectileStartDirection;
    protected PlaceholderFloat projectileVelocity;
    protected PlaceholderFloat projectileVelocityVertOffset;
    protected PlaceholderFloat projectileVelocityHorizOffset;
    protected float projectileVelocityAccuracy;
    protected float projectileVelocityVertNoise;
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    protected boolean stopOnHitEntity;
    protected boolean stopOnHitGround;
    protected boolean powerAffectsVelocity = true;
    protected boolean powerAffectsRange = true;
    protected boolean hitSelf = false;
    protected boolean hitTarget = true;
    protected boolean hitPlayers = true;
    protected boolean hitNonPlayers = false;
    protected boolean hitTargetOnly = false;
    protected boolean hitArmorStands = false;
    protected String hitConditionString;
    @MythicField(name="hitConditions", aliases={"conditions", "cond", "c"}, defValue="NONE", version="4.9", premium=true, description="Conditions applied to the hit target")
    protected List<SkillCondition> hitConditions = null;

    public Projectile(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onBounceSkillName = mlc.getString(new String[]{"onbounceskill", "onbounce"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        String type = mlc.getString("type", "NORMAL");
        try {
            this.type = ProjectileType.valueOf(type.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid projectile type specified");
            this.type = ProjectileType.NORMAL;
        }
        String bulletType = mlc.getString(new String[]{"bullettype", "bullet", "b"}, "NONE", new String[0]);
        try {
            this.bulletType = BulletType.valueOf(bulletType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet type specified");
            this.bulletType = BulletType.NONE;
        }
        switch (this.bulletType) {
            case TRACKING: 
            case BLOCK: 
            case ITEM: 
            case SMALLBLOCK: {
                String strBulletMaterial = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                try {
                    Optional<ModelEngineSupport> support = ((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine();
                    if (!strBulletMaterial.contains(":") || !support.isPresent()) {
                        this.bulletMaterial = Material.valueOf((String)strBulletMaterial.toUpperCase());
                        this.bulletModelId = mlc.getInteger(new String[]{"bulletmodel", "model"}, 0);
                        this.bulletMatchDirection = mlc.getBoolean(new String[]{"bulletsmall"}, false);
                    } else {
                        ((MythicBukkit)this.getPlugin()).getSkillManager().queueAfterLoad(() -> {
                            try {
                                String[] mat = strBulletMaterial.split(":");
                                BlueprintBone bone = ((ModelEngineSupport)support.get()).getBlueprintBone(mat[0], mat[1]);
                                int id = bone.getItemId();
                                if (id == -1) {
                                    throw new Exception();
                                }
                                this.bulletModelId = id;
                                this.bulletMaterial = Material.LEATHER_HORSE_ARMOR;
                                this.bulletMatchDirection = bone.getOption("small");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    this.bulletColor = mlc.getString(new String[]{"bulletcolor"}, null, new String[0]);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Specified bullet material does not exist");
                    this.bulletMaterial = Material.STONE;
                }
                break;
            }
            case MYTHICITEM: {
                String strMythicItem = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(strMythicItem);
                maybeItem.ifPresent(mythicItem -> {
                    this.bulletMythicItem = mythicItem;
                });
                break;
            }
            case MOB: {
                this.bulletMatchDirection = mlc.getBoolean(new String[]{"bulletmatchdirection", "bmd"}, false);
                break;
            }
        }
        this.bulletSpin = mlc.getFloat(new String[]{"bulletspin", "bspin"}, 0.0f);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 1);
        this.ticksPerSecond = 20.0f / (float)this.tickInterval;
        this.hitRadius = mlc.getPlaceholderFloat(new String[]{"horizontalradius", "hradius", "hr", "r"}, 1.25f, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"maxduration", "duration", "md", "d"}, 400, new String[0]);
        float range = mlc.getFloat(new String[]{"maxrange", "mr"}, 40.0f);
        this.maxDistanceSquared = range * range;
        this.deathDelay = mlc.getPlaceholderInteger(new String[]{"deathdelay", "death", "dd"}, 2, new String[0]);
        this.verticalHitRadius = mlc.getFloat(new String[]{"verticalradius", "vradius", "vr"}, 1.25f);
        this.startYOffset = mlc.getPlaceholderDouble(new String[]{"startyoffset", "syo"}, 1.0, new String[0]);
        this.startForwardOffset = mlc.getPlaceholderFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 1.0f, new String[0]);
        this.targetYOffset = mlc.getPlaceholderDouble(new String[]{"targetyoffset", "targety", "tyo"}, 0.0, new String[0]);
        String projectileStartDirection = mlc.getString(new String[]{"startingdirection", "startingdir", "startdir", "sdir"}, null, new String[0]);
        this.projectileStartDirection = projectileStartDirection != null ? Optional.of(this.parseSkillTargeter(projectileStartDirection)) : Optional.empty();
        float sideOffset = mlc.getFloat(new String[]{"sideoffset", "soffset", "so"}, 0.0f);
        this.startSideOffset = mlc.getPlaceholderDouble(new String[]{"startsideoffset", "ssoffset", "sso"}, sideOffset, new String[0]);
        this.endSideOffset = mlc.getPlaceholderDouble(new String[]{"endoffset", "esoffset", "eso"}, sideOffset, new String[0]);
        this.projectileVelocity = mlc.getPlaceholderFloat(new String[]{"velocity", "v"}, 5.0f, new String[0]);
        this.projectileVelocityVertOffset = mlc.getPlaceholderFloat(new String[]{"verticaloffset", "vo"}, 0.0f, new String[0]);
        this.projectileVelocityHorizOffset = mlc.getPlaceholderFloat(new String[]{"horizontaloffset", "ho"}, 0.0f, new String[0]);
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise);
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        this.stopOnHitEntity = mlc.getBoolean(new String[]{"stopatentity", "se"}, true);
        this.stopOnHitGround = mlc.getBoolean(new String[]{"stopatblock", "sb"}, true);
        this.powerAffectsVelocity = mlc.getBoolean(new String[]{"poweraffectsvelocity", "pav"}, true);
        this.powerAffectsRange = mlc.getBoolean(new String[]{"poweraffectsrange", "par"}, true);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        this.hitTarget = mlc.getBoolean(new String[]{"hittarget", "ht"}, true);
        this.hitTargetOnly = mlc.getBoolean(new String[]{"hittargetonly", "hto"}, false);
        this.hitConditionString = mlc.getString(new String[]{"hitconditions", "conditions", "cond", "c"}, "null", new String[0]);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onTickSkillName);
            }
            if (this.onHitSkillName != null) {
                this.onHitSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onHitSkillName);
            }
            if (this.onBounceSkillName != null) {
                this.onBounceSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onBounceSkillName);
            }
            if (this.onEndSkillName != null) {
                this.onEndSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onEndSkillName);
            }
            if (this.onStartSkillName != null) {
                this.onStartSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onStartSkillName);
            }
            if (this.bulletType == BulletType.MOB) {
                String mobType = mlc.getString(new String[]{"mob", "mobtype", "mm"}, "SkeletalKnight", new String[0]);
                this.bulletMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(mobType).orElseGet(() -> null);
                if (this.bulletMob == null) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet mob type specified");
                    this.bulletType = BulletType.NONE;
                }
            }
            if (this.hitConditionString != null && MythicBukkit.isVolatile()) {
                this.hitConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.hitConditionString);
            }
        });
    }

    public PlaceholderDouble getTargetYOffset() {
        return this.targetYOffset;
    }

    protected static enum ProjectileType {
        NORMAL,
        METEOR;

    }

    protected static enum BulletType {
        NONE,
        TRACKING,
        ITEM,
        BLOCK,
        SMALLBLOCK,
        MYTHICITEM,
        ARROW,
        MOB;

    }

    public abstract class ProjectileTracker
    implements IParentSkill,
    Runnable,
    Terminable {
        protected final TerminableRegistry components = TerminableRegistry.create();
        protected SkillMetadata data;
        protected int chargesRemaining;
        protected int ticksRemaining;
        protected int deathDelay;
        protected AbstractEntity bullet = null;
        protected float power;
        protected AbstractLocation startLocation;
        protected AbstractLocation previousLocation;
        protected AbstractLocation currentLocation;
        protected AbstractVector currentVelocity;
        protected Set<AbstractEntity> inRange = ConcurrentHashMap.newKeySet();
        protected HashSet<AbstractEntity> targets = new HashSet();
        protected HashMap<AbstractEntity, Long> immune = new HashMap();

        public ProjectileTracker(SkillMetadata data, AbstractLocation target) {
            this.data = data.deepClone();
            this.data.setCallingEvent(this);
            this.data.setIsAsync(true);
            this.power = data.getPower();
            this.ticksRemaining = Projectile.this.duration.get(data);
            this.deathDelay = Projectile.this.deathDelay.get(data);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ Projectile fired by Entity {0}: skill = {1}", data.getCaster().getEntity().getName(), Projectile.this.line);
        }

        private void evaluatePotentialTargets() {
            this.inRange.clear();
            if (Projectile.this.hitSelf || Projectile.this.hitPlayers || Projectile.this.hitNonPlayers) {
                this.inRange.addAll(((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(this.currentLocation, Projectile.this.hitRadius.get(this.data)));
                Optional<ModelEngineSupport> megSupport = ((MythicBukkit)Projectile.this.getPlugin()).getCompatibility().getModelEngine();
                this.inRange.removeIf(e -> {
                    if (megSupport.isPresent()) {
                        e = ((ModelEngineSupport)megSupport.get()).getParent((AbstractEntity)e);
                    }
                    if (e == null) {
                        return true;
                    }
                    if (BULLET_ENTITIES.contains(e)) {
                        return true;
                    }
                    if (!e.isLiving() || e.isCitizensNPC()) {
                        return true;
                    }
                    if (!Projectile.this.hitSelf && e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!Projectile.this.hitPlayers && e.isPlayer()) {
                        return true;
                    }
                    if (!Projectile.this.hitNonPlayers && !e.isPlayer()) {
                        return true;
                    }
                    if (this.bullet != null && this.bullet.getUniqueId().equals(e.getUniqueId())) {
                        return true;
                    }
                    if (Projectile.this.hitConditions != null) {
                        for (SkillCondition condition : Projectile.this.hitConditions) {
                            if (condition.evaluateEntity((AbstractEntity)e)) continue;
                            return true;
                        }
                    }
                    return false;
                });
            }
        }

        public void evaluateTargetsInBB() {
            if (this.inRange != null && !this.inRange.isEmpty()) {
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 2000L);
                for (AbstractEntity e : this.inRange) {
                    if (e.isDead() || this.immune.containsKey(e)) continue;
                    boolean hit = false;
                    Optional<ModelEngineSupport> support = ((MythicBukkit)Projectile.this.getPlugin()).getCompatibility().getModelEngine();
                    if (support.isPresent() && support.get().overlapsOOBB(this.getBoundingBox(), e)) {
                        hit = true;
                    }
                    if (this.getBoundingBox().overlaps(e.getBukkitEntity().getBoundingBox())) {
                        hit = true;
                    }
                    if (!hit) continue;
                    this.immune.put(e, System.currentTimeMillis() + 2000L);
                    MythicProjectileHitEvent hitEvent = Events.callAndReturn(new MythicProjectileHitEvent(this, e));
                    if (hitEvent.isCancelled()) continue;
                    this.targets.add(e);
                    if (!Projectile.this.stopOnHitEntity) continue;
                    break;
                }
            }
        }

        public boolean executeProjectileSkill(Optional<Skill> skill, SkillMetadata data, boolean atCaster) {
            if (skill == null) {
                return true;
            }
            if (!skill.isPresent()) {
                return true;
            }
            data = data.deepClone();
            if (atCaster) {
                data.setEntityTarget(data.getCaster().getEntity());
            }
            if (skill.get().isUsable(data)) {
                VariableRegistry vars = data.getVariables();
                skill.get().execute(data);
                return true;
            }
            return false;
        }

        public void setPower(float p) {
            this.power = p;
        }

        public void modifyPower(float p) {
            this.power *= p;
        }

        public BoundingBox getBoundingBox() {
            return BoundingBox.of((Location)BukkitAdapter.adapt(this.currentLocation), (double)Projectile.this.hitRadius.get(this.data), (double)Projectile.this.verticalHitRadius, (double)Projectile.this.hitRadius.get(this.data));
        }

        public boolean start() {
            this.components.accept(Events.subscribe(WorldUnloadEvent.class).filter(event -> event.getWorld().getUID().equals(this.startLocation.getWorld().getUniqueId())).handler(event -> this.terminate()));
            Promise.start().thenRunSync(() -> {
                this.projectileStart();
                if (Projectile.this.bulletType != BulletType.NONE) {
                    this.spawnBullet();
                    if (Projectile.this.bulletType == BulletType.BLOCK) {
                        this.components.accept(Events.subscribe(EntityChangeBlockEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)));
                    } else if (Projectile.this.bulletType == BulletType.MOB || Projectile.this.bulletType == BulletType.TRACKING) {
                        this.components.accept(Events.subscribe(PlayerInteractEntityEvent.class).filter(event -> event.getRightClicked() != null).filter(event -> event.getRightClicked().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)));
                    } else if (Projectile.this.bulletType == BulletType.ARROW) {
                        this.components.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> this.bullet != null).filter(event -> event.getDamager() != null).filter(event -> event.getDamager().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)));
                    }
                    this.components.accept(Events.subscribe(ChunkUnloadEvent.class).filter(event -> event.getChunk().equals(this.bullet.getBukkitEntity().getChunk())).handler(event -> {
                        Log.info("Chunk unload, removing projectile bullet");
                        this.terminate();
                    }));
                    this.components.accept(Events.subscribe(WorldUnloadEvent.class).filter(event -> event.getWorld().equals(this.bullet.getBukkitEntity().getWorld())).handler(event -> this.terminate()));
                }
                if (Projectile.this.onStartSkill.isPresent() && Projectile.this.onStartSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                    targets.add(this.startLocation);
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.currentLocation.clone());
                    Projectile.this.onStartSkill.get().execute(sData);
                }
                this.run();
                this.components.accept(Schedulers.sync().runRepeating(this, 0L, (long)Projectile.this.tickInterval));
            });
            return true;
        }

        @Override
        public void run() {
            this.ticksRemaining -= Projectile.this.tickInterval;
            if (this.data.getCaster() != null && this.data.getCaster().getEntity().isDead()) {
                this.terminate();
                return;
            }
            if (this.currentLocation.distanceSquared(this.startLocation) >= (double)Projectile.this.maxDistanceSquared) {
                this.terminate();
                return;
            }
            if (this.ticksRemaining <= 0) {
                this.terminate();
                return;
            }
            this.evaluatePotentialTargets();
            this.projectileTick();
        }

        public abstract void projectileStart();

        public abstract void projectileTick();

        public void projectileEnd() {
        }

        @Override
        public void close() {
            if (!this.components.hasTerminated()) {
                this.projectileEnd();
                if (Projectile.this.bulletType != BulletType.NONE) {
                    Schedulers.sync().runLater(() -> {
                        if (this.bullet != null) {
                            this.bullet.remove();
                            BULLET_ENTITIES.remove(this.bullet);
                        }
                    }, this.deathDelay);
                }
                if (Projectile.this.onEndSkill.isPresent() && Projectile.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    Projectile.this.onEndSkill.get().execute(sData.setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
                }
                if (this.inRange != null) {
                    this.inRange.clear();
                }
            }
            this.components.closeAndReportException();
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        private void spawnBullet() {
            if (Projectile.this.bulletType == BulletType.TRACKING) {
                ArmorStand armorStand;
                if (this.hasTerminated()) {
                    return;
                }
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 1.4375, 0.0);
                Location location = BukkitAdapter.adapt(l);
                if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                    armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND, CreatureSpawnEvent.SpawnReason.CUSTOM, entity -> {
                        ArmorStand as = (ArmorStand)entity;
                        as.setInvisible(true);
                        as.setAI(true);
                        as.setTicksLived(Integer.MAX_VALUE);
                        as.setInvulnerable(true);
                        as.setMarker(true);
                        as.setGravity(false);
                        as.setRemoveWhenFarAway(true);
                    });
                } else {
                    armorStand = (ArmorStand)((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().spawnInvisibleArmorStand(location);
                    armorStand.setInvisible(true);
                    armorStand.setAI(true);
                    armorStand.setTicksLived(Integer.MAX_VALUE);
                    armorStand.setInvulnerable(true);
                    armorStand.setGravity(false);
                    armorStand.setRemoveWhenFarAway(true);
                }
                ItemFactory bulletItem = ItemFactory.of(Projectile.this.bulletMaterial).model(Projectile.this.bulletModelId);
                if (Projectile.this.bulletColor != null) {
                    bulletItem.color(Projectile.this.bulletColor);
                }
                armorStand.getEquipment().setHelmet(bulletItem.build());
                this.bullet = BukkitAdapter.adapt((Entity)armorStand);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    armorStand.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.BLOCK) {
                if (this.hasTerminated()) {
                    return;
                }
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.5, 0.0);
                FallingBlock block = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), Projectile.this.bulletMaterial.createBlockData()) : BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), Projectile.this.bulletMaterial, (byte)0);
                block.setHurtEntities(false);
                block.setDropItem(false);
                block.setTicksLived(Integer.MAX_VALUE);
                block.setInvulnerable(true);
                block.setGravity(false);
                this.bullet = BukkitAdapter.adapt((Entity)block);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    block.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.MYTHICITEM) {
                ItemStack i = BukkitAdapter.adapt(Projectile.this.bulletMythicItem.generateItemStack(1));
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.35, 0.0);
                Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                item.setTicksLived(Integer.MAX_VALUE);
                item.setInvulnerable(true);
                item.setGravity(false);
                item.setPickupDelay(Integer.MAX_VALUE);
                this.bullet = BukkitAdapter.adapt((Entity)item);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    item.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.SMALLBLOCK) {
                AbstractLocation l = this.currentLocation.clone();
                ArmorStand block = (ArmorStand)BukkitAdapter.adapt(l).getWorld().spawnEntity(BukkitAdapter.adapt(l), EntityType.ARMOR_STAND);
                block.setCustomName("Dinnerbone");
                block.setCustomNameVisible(false);
                block.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
                block.getEquipment().setHelmet(new ItemStack(Projectile.this.bulletMaterial));
                block.setArms(false);
                block.setBasePlate(false);
                block.setVisible(false);
                block.setTicksLived(Integer.MAX_VALUE);
                block.setInvulnerable(true);
                this.bullet = BukkitAdapter.adapt((Entity)block);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(this.bullet);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    block.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.ITEM) {
                ItemStack i = ItemFactory.of(Projectile.this.bulletMaterial).model(Projectile.this.bulletModelId).build();
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.35, 0.0);
                Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                item.setTicksLived(Integer.MAX_VALUE);
                item.setInvulnerable(true);
                item.setGravity(false);
                item.setPickupDelay(Integer.MAX_VALUE);
                this.bullet = BukkitAdapter.adapt((Entity)item);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    item.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.MOB && Projectile.this.bulletMob != null) {
                AbstractLocation l = this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                ActiveMob am = Projectile.this.bulletMob.spawn(l, 1.0, SpawnReason.OTHER, entity -> {
                    entity.setTicksLived(Integer.MAX_VALUE);
                    entity.setInvulnerable(true);
                    entity.setVelocity(BukkitAdapter.adapt(this.currentVelocity));
                    if (entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
                        ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(BukkitAdapter.adapt(entity));
                        ((ArmorStand)entity).setAI(true);
                        ((ArmorStand)entity).setRemoveWhenFarAway(true);
                    } else {
                        entity.setGravity(false);
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).setRemoveWhenFarAway(true);
                        }
                    }
                });
                Entity entity2 = am.getEntity().getBukkitEntity();
                am.setParent(this.data.getCaster());
                am.setOwner(this.data.getCaster().getEntity().getUniqueId());
                this.bullet = BukkitAdapter.adapt(entity2);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    this.bullet.remove();
                }
                this.bullet.teleport(this.currentLocation.clone().subtract(0.0, 1.35, 0.0));
            } else if (Projectile.this.bulletType == BulletType.ARROW) {
                AbstractLocation l = this.currentLocation.clone();
                Location loc = BukkitAdapter.adapt(l);
                Arrow arrow = (Arrow)loc.getWorld().spawn(loc, Arrow.class);
                arrow.setTicksLived(Integer.MAX_VALUE);
                arrow.setInvulnerable(true);
                arrow.setGravity(false);
                arrow.setVelocity(BukkitAdapter.adapt(this.currentVelocity).multiply(0.25));
                this.bullet = BukkitAdapter.adapt((Entity)arrow);
                BULLET_ENTITIES.add(this.bullet);
                ((MythicBukkit)Projectile.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    arrow.remove();
                }
            }
            if (this.bullet != null) {
                this.bullet.getBukkitEntity().setPersistent(false);
                this.applyBulletVelocity();
            }
        }

        public abstract void applyBulletVelocity();

        protected void orientBulletArmorStand() {
            if (this.bullet == null) {
                return;
            }
            if (!(this.bullet.getBukkitEntity() instanceof ArmorStand)) {
                return;
            }
            ArmorStand stand = (ArmorStand)this.bullet.getBukkitEntity();
            Location to = BukkitAdapter.adapt(this.currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(this.currentVelocity);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            double pitch = Math.atan2(delta.getY(), len);
            stand.setHeadPose(new EulerAngle(-pitch, 0.0, 0.0));
            Location loc = to.clone().add(delta).subtract(0.0, 1.4375, 0.0);
            loc.setYaw((float)Math.toDegrees(-yaw));
            stand.teleport(loc);
        }

        public int getChargesRemaining() {
            return this.chargesRemaining;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }

        public int getDeathDelay() {
            return this.deathDelay;
        }

        public AbstractLocation getStartLocation() {
            return this.startLocation;
        }

        public AbstractLocation getPreviousLocation() {
            return this.previousLocation;
        }

        public AbstractLocation getCurrentLocation() {
            return this.currentLocation;
        }

        public AbstractVector getCurrentVelocity() {
            return this.currentVelocity;
        }

        public void setCurrentVelocity(AbstractVector currentVelocity) {
            this.currentVelocity = currentVelocity;
        }
    }
}

