/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.RandomFloat;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.variables.VariableScope;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scoreboard.Objective;

public class PlaceholderExecutor
extends ReloadableModule<MythicBukkit>
implements PlaceholderManager {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("([<][^<>]+[>])");
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private List<PlaceholderParser> parsers = Lists.newArrayList();
    private PlaceholderTree placeholders = new PlaceholderTree();
    private boolean initialized = false;

    public PlaceholderExecutor(MythicBukkit plugin) {
        super(plugin);
        this.load(plugin);
    }

    @Override
    public void unload() {
        this.parsers.clear();
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.initialized = false;
        this.placeholders = new PlaceholderTree();
        this.register("echo", (Placeholder)Placeholder.general(arg -> arg));
        this.register("caster.name", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster caster = meta.getCaster();
            if (caster instanceof ActiveMob) {
                if (((ActiveMob)caster).getDisplayName() != null) {
                    return ((ActiveMob)caster).getDisplayName();
                }
                String name = ((ActiveMob)caster).getEntity().getBukkitEntity().getType().getName();
                name = WordUtils.capitalize((String)name);
                return name;
            }
            if (caster.getEntity().isPlayer()) {
                return caster.getEntity().asPlayer().getName();
            }
            return caster.getEntity().getName();
        }));
        this.register("caster.display", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster caster = meta.getCaster();
            return caster.getEntity().getName();
        }));
        this.register("caster.uuid", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getUniqueId())));
        this.register("caster.l.w", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getWorld().getName())));
        this.register("caster.l.x", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getBlockX())));
        this.register("caster.l.y", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getBlockY())));
        this.register("caster.l.z", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getBlockZ())));
        this.register("caster.l.x.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getX())));
        this.register("caster.l.y.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getY())));
        this.register("caster.l.z.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getZ())));
        this.register("caster.l.yaw", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getYaw())));
        this.register("caster.l.pitch", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getPitch())));
        this.register("caster.velocity", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getEntity().getVelocity().length())));
        this.register("caster.hp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getEntity().getHealth())));
        this.register("caster.thp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getHealth())));
        this.register("caster.mhp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getEntity().getMaxHealth())));
        this.register("caster.php", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(100.0 * (meta.getCaster().getEntity().getHealth() / meta.getCaster().getEntity().getMaxHealth()))));
        this.register("caster.level", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getLevel())));
        this.register("caster.stance", (Placeholder)Placeholder.meta((meta, arg) -> meta.getCaster() instanceof ActiveMob ? String.valueOf(((ActiveMob)meta.getCaster()).getStance()) : "None"));
        this.register("caster.var", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.CASTER, (SkillMetadata)meta, null).getString((String)arg))));
        this.register("caster.luck", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getLuck())));
        this.register("caster.enchantlevel", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getEnchantmentLevel((String)arg))));
        this.register("caster.heldenchantlevel", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getEnchantmentLevelHeld((String)arg))));
        this.register("caster.damage", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster caster = meta.getCaster();
            if (caster instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)caster).getDamage());
            }
            if (caster.getEntity().isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(caster.getEntity().asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("caster.score", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity target = meta.getCaster().getEntity();
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = target.isPlayer() ? obj.getScore(target.asPlayer().getName()).getScore() : obj.getScore(target.getUniqueId().toString()).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("caster.tt.top", (Placeholder)Placeholder.meta((meta, arg) -> {
            ActiveMob am;
            if (meta.getCaster() instanceof ActiveMob && (am = (ActiveMob)meta.getCaster()).hasThreatTable() && am.getThreatTable().inCombat()) {
                return am.getThreatTable().getTopThreatHolder().getName();
            }
            return "Unknown";
        }));
        this.register("caster.tt.size", (Placeholder)Placeholder.meta((meta, arg) -> {
            ActiveMob am;
            if (meta.getCaster() instanceof ActiveMob && (am = (ActiveMob)meta.getCaster()).hasThreatTable()) {
                return String.valueOf(am.getThreatTable().size());
            }
            return String.valueOf(0);
        }));
        this.register("skill.var", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (meta instanceof SkillMetadata) {
                SkillMetadata data = (SkillMetadata)meta;
                return data.getVariables().getString((String)arg);
            }
            return null;
        }));
        this.register("skill.targets", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (meta instanceof SkillMetadata) {
                SkillMetadata data = (SkillMetadata)meta;
                if (!data.getEntityTargets().isEmpty()) {
                    return String.valueOf(data.getEntityTargets().size());
                }
                if (!data.getLocationTargets().isEmpty()) {
                    return String.valueOf(data.getLocationTargets().size());
                }
                return "0";
            }
            return "0";
        }));
        this.register("skill", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (arg == null) {
                return null;
            }
            if (meta instanceof SkillMetadata) {
                String parameter;
                SkillMetadata data = (SkillMetadata)meta;
                String def = null;
                if (arg.contains("|")) {
                    String[] split = arg.split("\\|");
                    arg = split[0];
                    try {
                        def = split[1];
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if ((parameter = ((SkillMetadata)meta).getParameters().get(arg)) == null) {
                    return def;
                }
                return parameter;
            }
            return null;
        }));
        this.register("trigger.name", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity trigger = meta.getTrigger();
            if (trigger == null) {
                return "Unknown";
            }
            if (trigger.isPlayer()) {
                return trigger.asPlayer().getName();
            }
            return trigger.getName();
        }));
        this.register("trigger.uuid", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getUniqueId())));
        this.register("trigger.l.w", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getWorld().getName())));
        this.register("trigger.l.x", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getBlockX())));
        this.register("trigger.l.y", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getBlockY())));
        this.register("trigger.l.z", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getBlockZ())));
        this.register("trigger.l.x.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getX())));
        this.register("trigger.l.y.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getY())));
        this.register("trigger.l.z.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getZ())));
        this.register("trigger.l.yaw", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getYaw())));
        this.register("trigger.l.pitch", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getPitch())));
        this.register("trigger.hp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getTrigger().getHealth())));
        this.register("trigger.thp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getHealth())));
        this.register("trigger.mhp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getTrigger().getMaxHealth())));
        this.register("trigger.php", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(100.0 * (meta.getTrigger().getHealth() / meta.getTrigger().getMaxHealth()))));
        this.register("trigger.var", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.TARGET, meta.getTrigger()).getString((String)arg))));
        this.register("trigger.luck", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLuck())));
        this.register("trigger.score", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity target = meta.getTrigger();
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = target.isPlayer() ? obj.getScore(target.asPlayer().getName()).getScore() : obj.getScore(target.getUniqueId().toString()).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("trigger.threat", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((ActiveMob)meta.getCaster()).getThreatTable().getThreat(meta.getTrigger()))));
        this.register("trigger.damage", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (meta.getTrigger() instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)((Object)meta.getTrigger())).getDamage());
            }
            if (meta.getTrigger().isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(meta.getTrigger().asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("trigger.held.item", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity trigger = meta.getTrigger();
            if (trigger == null || !trigger.isLiving()) {
                return "AIR";
            }
            LivingEntity entity = (LivingEntity)trigger.getBukkitEntity();
            if (entity.getEquipment().getItemInMainHand() == null) {
                return "AIR";
            }
            return entity.getEquipment().getItemInMainHand().getType().toString();
        }));
        this.register("target.name", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (entity == null) {
                return "Unknown";
            }
            if (entity.isPlayer()) {
                return entity.asPlayer().getName();
            }
            if (entity.getName() != null) {
                return entity.getName();
            }
            return entity.getBukkitEntity().getType().getName();
        }));
        this.register("target.uuid", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getUniqueId())));
        this.register("target.entity_type", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getBukkitEntity().getType().toString())));
        this.register("target.l.w", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getWorld().getName())));
        this.register("target.l.x", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getBlockX())));
        this.register("target.l.y", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getBlockY())));
        this.register("target.l.z", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getBlockZ())));
        this.register("target.l.x.double", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getX())));
        this.register("target.l.y.double", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getY())));
        this.register("target.l.z.double", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getZ())));
        this.register("target.l.yaw", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getYaw())));
        this.register("target.l.pitch", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getPitch())));
        this.register("target.hp", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf((int)entity.getHealth())));
        this.register("target.thp", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getHealth())));
        this.register("target.mhp", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf((int)entity.getMaxHealth())));
        this.register("target.php", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(100.0 * (entity.getHealth() / entity.getMaxHealth()))));
        this.register("target.level", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (entity instanceof ActiveMob) {
                return String.valueOf((int)((ActiveMob)((Object)entity)).getLevel());
            }
            return "0";
        }));
        this.register("target.damage", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (entity instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)((Object)entity)).getDamage());
            }
            if (entity.isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(entity.asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("target.var", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.TARGET, (AbstractEntity)entity).getString((String)arg))));
        this.register("target.luck", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLuck())));
        this.register("target.score", (Placeholder)Placeholder.entity((entity, arg) -> {
            AbstractEntity target = entity;
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = target.isPlayer() ? obj.getScore(target.asPlayer().getName()).getScore() : obj.getScore(target.getUniqueId().toString()).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("target.ydiff", (Placeholder)Placeholder.target((meta, entity, arg) -> {
            double tY = entity.getLocation().getY();
            double cY = meta.getCaster().getEntity().getLocation().getY();
            return String.valueOf(tY - cY);
        }));
        this.register("target.block.type", (Placeholder)Placeholder.location((location, arg) -> {
            try {
                return String.valueOf(BukkitAdapter.adapt(location).getBlock().getType().toString());
            }
            catch (Exception ex) {
                return "AIR";
            }
        }));
        this.register("target.block.hardness", (Placeholder)Placeholder.location((location, arg) -> {
            try {
                return String.valueOf(BukkitAdapter.adapt(location).getBlock().getType().getHardness());
            }
            catch (Exception ex) {
                return "0";
            }
        }));
        this.register("target.held.item", (Placeholder)Placeholder.target((meta, target, arg) -> {
            if (target == null || !target.isLiving()) {
                return "AIR";
            }
            LivingEntity entity = (LivingEntity)target.getBukkitEntity();
            if (entity.getEquipment().getItemInMainHand() == null) {
                return "AIR";
            }
            return entity.getEquipment().getItemInMainHand().getType().toString();
        }));
        this.register("parent.name", (Placeholder)Placeholder.parent((entity, arg) -> {
            if (entity == null) {
                return "Unknown";
            }
            if (entity.isPlayer()) {
                return entity.asPlayer().getName();
            }
            return entity.getName();
        }));
        this.register("parent.uuid", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getUniqueId())));
        this.register("parent.l.w", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getWorld().getName())));
        this.register("parent.l.x", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getBlockX())));
        this.register("parent.l.y", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getBlockY())));
        this.register("parent.l.z", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getBlockZ())));
        this.register("parent.l.z.double", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getX())));
        this.register("parent.l.z.double", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getY())));
        this.register("parent.l.z.double", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getZ())));
        this.register("parent.hp", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf((int)entity.getHealth())));
        this.register("parent.thp", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getHealth())));
        this.register("parent.mhp", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf((int)entity.getMaxHealth())));
        this.register("parent.php", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(100.0 * (entity.getHealth() / entity.getMaxHealth()))));
        this.register("parent.damage", (Placeholder)Placeholder.parent((entity, arg) -> {
            if (entity instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)((Object)entity)).getDamage());
            }
            if (entity.isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(entity.asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("parent.var", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.TARGET, (AbstractEntity)entity).getString((String)arg))));
        this.register("spawner.pir", (Placeholder)Placeholder.spawner((spawner, arg) -> {
            double radius = spawner.getScalingRange();
            int players = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(spawner.getLocation(), radius, entity -> entity.isPlayer()).size();
            return String.valueOf(players);
        }));
        this.register("random", (Placeholder)Placeholder.general(arg -> String.valueOf(new RandomInt((String)arg).get())));
        this.register("random.float", (Placeholder)Placeholder.general(arg -> String.valueOf(new RandomFloat((String)arg).get())));
        this.register("random.float.rounded", (Placeholder)Placeholder.general(arg -> String.valueOf(df.format(new RandomFloat((String)arg).get()))));
        this.register("score", (Placeholder)Placeholder.general(arg -> {
            String[] split = arg.split("\\.");
            if (split.length < 2) {
                return null;
            }
            String objective = split[0];
            String entry = split[1];
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objective);
            int score = 0;
            if (obj != null) {
                score = obj.getScore(entry).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("world.var", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.WORLD, (SkillMetadata)meta, meta.getTrigger()).getString((String)arg))));
        this.register("global.var", (Placeholder)Placeholder.general(arg -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.GLOBAL, null, null).getString((String)arg))));
        this.register("global.score", (Placeholder)Placeholder.general(arg -> {
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = obj.getScore("__GLOBAL__").getScore();
            }
            return String.valueOf(score);
        }));
        this.initialized = true;
    }

    @Override
    public void register(String[] keys, Placeholder transformer) {
        for (String key : keys) {
            this.register(key, transformer);
        }
    }

    @Override
    public void register(String key, Placeholder transformer) {
        String[] split = key.split("\\.");
        PlaceholderTree ref = this.placeholders;
        for (int i = 0; i <= split.length; ++i) {
            if (i == split.length) {
                ref.setPlaceholder(transformer);
                continue;
            }
            if (!ref.getSubPlaceholders().containsKey(split[i])) {
                ref.getSubPlaceholders().put(split[i], new PlaceholderTree());
            }
            ref = ref.getSubPlaceholders().get(split[i]);
        }
        if (this.initialized) {
            this.recheckForPlaceholders();
        }
    }

    @Override
    public PlaceholderEntry getPlaceholder(String key) {
        if (key.startsWith("&")) {
            return null;
        }
        String[] split = key.split("\\.");
        PlaceholderTree ref = this.placeholders;
        String arg = null;
        for (int i = 0; i < split.length; ++i) {
            if (ref.getSubPlaceholders().containsKey(split[i])) {
                ref = ref.getSubPlaceholders().get(split[i]);
                continue;
            }
            arg = arg == null ? split[i] : arg + "." + split[i];
        }
        return new PlaceholderEntry(ref.getPlaceholder(), arg);
    }

    @Override
    public boolean checkForVariables(String string) {
        return VARIABLE_PATTERN.matcher(string).find();
    }

    public Matcher matcher(String string) {
        return VARIABLE_PATTERN.matcher(string);
    }

    @Override
    public void registerParser(PlaceholderParser placeholderParser) {
        this.parsers.add(placeholderParser);
    }

    @Override
    public void recheckForPlaceholders() {
        this.parsers.forEach(parser -> parser.checkForVariables());
    }

    private class PlaceholderTree {
        private Placeholder placeholder = null;
        private Map<String, PlaceholderTree> subPlaceholders = new HashMap<String, PlaceholderTree>();

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public Map<String, PlaceholderTree> getSubPlaceholders() {
            return this.subPlaceholders;
        }

        public void setPlaceholder(Placeholder placeholder) {
            this.placeholder = placeholder;
        }

        public void setSubPlaceholders(Map<String, PlaceholderTree> subPlaceholders) {
            this.subPlaceholders = subPlaceholders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderTree)) {
                return false;
            }
            PlaceholderTree other = (PlaceholderTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Placeholder this$placeholder = this.getPlaceholder();
            Placeholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            Map<String, PlaceholderTree> this$subPlaceholders = this.getSubPlaceholders();
            Map<String, PlaceholderTree> other$subPlaceholders = other.getSubPlaceholders();
            return !(this$subPlaceholders == null ? other$subPlaceholders != null : !((Object)this$subPlaceholders).equals(other$subPlaceholders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderTree;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Placeholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            Map<String, PlaceholderTree> $subPlaceholders = this.getSubPlaceholders();
            result = result * 59 + ($subPlaceholders == null ? 43 : ((Object)$subPlaceholders).hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderTree(placeholder=" + this.getPlaceholder() + ", subPlaceholders=" + this.getSubPlaceholders() + ")";
        }
    }

    public class PlaceholderEntry {
        private final Placeholder placeholder;
        private final String arg;

        public PlaceholderEntry(Placeholder p, String a) {
            this.placeholder = p;
            this.arg = a != null ? a : "null";
        }

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public String getArg() {
            return this.arg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderEntry)) {
                return false;
            }
            PlaceholderEntry other = (PlaceholderEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Placeholder this$placeholder = this.getPlaceholder();
            Placeholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            String this$arg = this.getArg();
            String other$arg = other.getArg();
            return !(this$arg == null ? other$arg != null : !this$arg.equals(other$arg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Placeholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            String $arg = this.getArg();
            result = result * 59 + ($arg == null ? 43 : $arg.hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderEntry(placeholder=" + this.getPlaceholder() + ", arg=" + this.getArg() + ")";
        }
    }
}

