/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="weather", description="Changes the weather")
public class WeatherMechanic
extends SkillMechanic
implements INoTargetSkill {
    int type;
    int duration;

    public WeatherMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String t2 = mlc.getString(new String[]{"type", "t"}, "sunny", new String[0]);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 500);
        switch (t2.toLowerCase()) {
            case "sunny": 
            case "sun": 
            case "clear": {
                this.type = 0;
                break;
            }
            case "rain": 
            case "rainy": {
                this.type = 1;
                break;
            }
            case "stormy": 
            case "storm": 
            case "thunder": 
            case "thundering": {
                this.type = 2;
                break;
            }
            default: {
                this.type = 0;
            }
        }
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        switch (this.type) {
            case 0: {
                data.getCaster().getEntity().getWorld().setStorm(false);
                break;
            }
            case 1: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                data.getCaster().getEntity().getWorld().setThundering(false);
                break;
            }
            case 2: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                data.getCaster().getEntity().getWorld().setThundering(true);
            }
        }
        data.getCaster().getEntity().getWorld().setWeatherDuration(this.duration);
        return SkillResult.SUCCESS;
    }
}

