/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="velocity", description="Sets the velocity on the target entity")
public class VelocityMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat velocityX;
    protected PlaceholderFloat velocityY;
    protected PlaceholderFloat velocityZ;
    protected VelocityMode mode;

    public VelocityMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.velocityX = mlc.getPlaceholderFloat(new String[]{"velocityx", "vx", "x"}, 1.0f, new String[0]);
        this.velocityY = mlc.getPlaceholderFloat(new String[]{"velocityy", "vy", "y"}, 1.0f, new String[0]);
        this.velocityZ = mlc.getPlaceholderFloat(new String[]{"velocityz", "vz", "z"}, 1.0f, new String[0]);
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]);
        switch (strMode.toUpperCase()) {
            case "ADD": {
                this.mode = VelocityMode.ADD;
                break;
            }
            case "REMOVE": {
                this.mode = VelocityMode.REMOVE;
                break;
            }
            case "MULTIPLY": {
                this.mode = VelocityMode.MULTIPLY;
                break;
            }
            case "DIVIDE": {
                this.mode = VelocityMode.DIVIDE;
                break;
            }
            default: {
                this.mode = VelocityMode.SET;
            }
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity e = target.getBukkitEntity();
        Vector v = e.getVelocity();
        if (this.mode.equals((Object)VelocityMode.SET)) {
            v = new Vector(this.velocityX.get(data, target), this.velocityY.get(data, target), this.velocityZ.get(data, target));
        } else if (this.mode.equals((Object)VelocityMode.ADD)) {
            v.setX(v.getX() + (double)this.velocityX.get(data, target));
            v.setY(v.getY() + (double)this.velocityY.get(data, target));
            v.setZ(v.getZ() + (double)this.velocityZ.get(data, target));
        } else if (this.mode.equals((Object)VelocityMode.MULTIPLY)) {
            v.setX(v.getX() * (double)this.velocityX.get(data, target));
            v.setY(v.getY() * (double)this.velocityY.get(data, target));
            v.setZ(v.getZ() * (double)this.velocityZ.get(data, target));
        } else if (this.mode.equals((Object)VelocityMode.REMOVE)) {
            v.setX(v.getX() - (double)this.velocityX.get(data, target));
            v.setY(v.getY() - (double)this.velocityY.get(data, target));
            v.setZ(v.getZ() - (double)this.velocityZ.get(data, target));
        } else if (this.mode.equals((Object)VelocityMode.DIVIDE)) {
            v.setX(v.getX() / (double)this.velocityX.get(data, target));
            v.setY(v.getY() / (double)this.velocityY.get(data, target));
            v.setZ(v.getZ() / (double)this.velocityZ.get(data, target));
        }
        if (v.length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        if (Double.isNaN(v.getX())) {
            v.setX(0);
        }
        if (Double.isNaN(v.getY())) {
            v.setY(0);
        }
        if (Double.isNaN(v.getZ())) {
            v.setZ(0);
        }
        e.setVelocity(v);
        return SkillResult.SUCCESS;
    }

    static enum VelocityMode {
        SET,
        ADD,
        MULTIPLY,
        REMOVE,
        DIVIDE;

    }
}

