/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import java.math.BigDecimal;

public class VariableAddMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected float amount;

    public VariableAddMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.amount = mlc.getFloat(new String[]{"amount", "a"}, 0.0f);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        VariableRegistry variables = this.getVariableManager().getRegistry(this.scope, data, target);
        Variable var = variables.get(this.key);
        if (var == null) {
            return SkillResult.INVALID_CONFIG;
        }
        if (var instanceof IntegerVariable) {
            int val = ((IntegerVariable)var).getValue();
            ((IntegerVariable)var).setValue(val + (int)this.amount);
        } else if (var instanceof FloatVariable) {
            BigDecimal val = new BigDecimal(var.toString());
            ((FloatVariable)var).setValue(val.add(new BigDecimal(String.valueOf(this.amount))).floatValue());
        } else {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not perform math operation on non-numeric variable type");
            return SkillResult.INVALID_CONFIG;
        }
        this.handleDuration(var);
        return SkillResult.SUCCESS;
    }
}

