/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Collection;
import java.util.HashSet;

@MythicMechanic(author="Ashijin", name="totem", aliases={"toteme", "t"}, description="Creates a static totem projectile at the target")
public class TotemMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderInt maxCharges;
    protected float YOffset;

    public TotemMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.maxCharges = mlc.getPlaceholderInteger(new String[]{"charges", "ch", "c"}, 0, new String[0]);
        this.YOffset = mlc.getFloat(new String[]{"yoffset", "yo"}, 1.0f);
        this.stopOnHitEntity = mlc.getBoolean(new String[]{"stopatentity", "se"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new TotemTracker(data, target.getLocation());
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Totem Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new TotemTracker(data, target);
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Totem Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    private class TotemTracker
    extends Projectile.ProjectileTracker {
        private AbstractLocation position;
        private int charges;

        public TotemTracker(SkillMetadata data, AbstractLocation target) {
            super(TotemMechanic.this, data, target);
            this.position = target;
            this.charges = TotemMechanic.this.maxCharges.get(data);
            this.start();
        }

        @Override
        public void projectileStart() {
            this.startLocation = this.position;
            this.currentLocation = this.position;
            if (TotemMechanic.this.YOffset != 0.0f) {
                this.currentLocation.setY(this.currentLocation.getY() + (double)TotemMechanic.this.YOffset);
            }
        }

        @Override
        public void projectileTick() {
            if (this.bullet != null) {
                if (TotemMechanic.this.bulletType == Projectile.BulletType.ITEM) {
                    AbstractLocation ol = this.currentLocation.clone();
                    ((MythicBukkit)TotemMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                    this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.previousLocation.toVector()));
                } else if (TotemMechanic.this.bulletType == Projectile.BulletType.MOB) {
                    AbstractLocation ol = this.currentLocation.clone();
                    if (TotemMechanic.this.bulletSpin != 0.0f) {
                        float newSpin = this.bullet.getLocation().getYaw() + TotemMechanic.this.bulletSpin;
                        ol.setYaw(newSpin);
                    }
                    this.bullet.teleport(ol);
                } else {
                    this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                    if (TotemMechanic.this.bulletSpin > 0.0f) {
                        float newSpin = this.bullet.getLocation().getYaw() + TotemMechanic.this.bulletSpin;
                        ((MythicBukkit)TotemMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                    }
                }
            }
            if (TotemMechanic.this.onTickSkill.isPresent() && ((Skill)TotemMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = TotemMechanic.this.bulletType == Projectile.BulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(location);
                sData.setLocationTargets(targets);
                sData.setOrigin(location);
                ((Skill)TotemMechanic.this.onTickSkill.get()).execute(sData);
            }
            this.evaluateTargetsInBB();
            if (!this.targets.isEmpty()) {
                this.doHit((Collection)this.targets.clone());
                if (TotemMechanic.this.stopOnHitEntity) {
                    this.terminate();
                }
                --this.charges;
                if (TotemMechanic.this.maxCharges.get(this.data) > 0 && this.charges <= 0) {
                    this.terminate();
                }
            }
            this.targets.clear();
        }

        public void doHit(Collection<AbstractEntity> targets) {
            if (TotemMechanic.this.onHitSkill.isPresent() && ((Skill)TotemMechanic.this.onHitSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                ((Skill)TotemMechanic.this.onHitSkill.get()).execute(sData);
            }
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        @Override
        public void applyBulletVelocity() {
        }
    }
}

