/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="takeitem", aliases={"take", "takeitems", "itemtake"}, description="Takes an item from the target")
public class TakeItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private BukkitItemStack item;
    private PlaceholderInt amount;

    public TakeItemMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        String materialString = mlc.getString(new String[]{"item", "i", "material", "m", "mi", "mythicitem"}, "DIRT", new String[0]);
        try {
            this.item = new BukkitItemStack(materialString);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + materialString + "' is not a valid material.");
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        int amountToRemove = this.amount.get(data, target);
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack inventoryItem = player.getInventory().getItem(i);
            if (inventoryItem == null || !this.item.isSimilar(inventoryItem)) continue;
            int slotAmount = inventoryItem.getAmount();
            int newAmount = Math.max(0, slotAmount - amountToRemove);
            amountToRemove = Math.max(0, amountToRemove - slotAmount);
            if (newAmount <= 0) {
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().destroyItem(inventoryItem);
                player.updateInventory();
                if (((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().isPresent()) {
                    ((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().get().reparseWeapon(target.asPlayer());
                }
            } else {
                inventoryItem.setAmount(newAmount);
            }
            if (amountToRemove == 0) break;
        }
        return SkillResult.SUCCESS;
    }
}

