/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class SpringMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private int tickDuration;
    private Material type;

    public SpringMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.tickDuration = mlc.getInteger(new String[]{"duration", "d"}, 40);
        String strType = mlc.getString(new String[]{"type", "t"}, "water", new String[0]);
        this.type = strType.equalsIgnoreCase("lava") ? Material.LAVA : (strType.equalsIgnoreCase("water") ? Material.WATER : Material.WATER);
        if (this.tickDuration <= 0) {
            this.tickDuration = 10;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data.getCaster(), target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data.getCaster(), target.getLocation());
        return SkillResult.SUCCESS;
    }

    protected void playEffect(SkillCaster am, AbstractLocation target) {
        Block block = BukkitAdapter.adapt(target).getBlock();
        if (block.getType() == Material.AIR) {
            block.setType(this.type, true);
            new Animator(target);
        }
    }

    private class Animator
    implements Runnable {
        private AbstractLocation location;

        public Animator(AbstractLocation location) {
            this.location = location;
            Schedulers.sync().runLater(this, SpringMechanic.this.tickDuration);
        }

        @Override
        public void run() {
            block2: {
                try {
                    BukkitAdapter.adapt(this.location).getBlock().setType(Material.AIR, true);
                }
                catch (Exception ex) {
                    if (ConfigExecutor.debugLevel <= 0) break block2;
                    ex.printStackTrace();
                }
            }
        }
    }
}

