/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="effect:spin", aliases={"spin", "e:spin"}, description="Forces the target entity to spin")
public class SpinEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt duration;
    protected PlaceholderInt velocity;

    public SpinEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 40, new String[0]);
        this.velocity = mlc.getPlaceholderInteger(new String[]{"velocity", "v"}, 18, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target, this.duration.get(data, target), this.velocity.get(data, target));
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable {
        private AbstractEntity target;
        private float yaw;
        private int velocity;
        private int duration;
        private int iteration;
        private Task task;

        public Animator(AbstractEntity target, int duration, int velocity) {
            this(duration, velocity);
            this.target = target;
            this.yaw = target.getLocation().getYaw();
        }

        protected Animator(int duration, int velocity) {
            this.velocity = velocity;
            this.duration = duration;
            this.iteration = 0;
            this.task = Schedulers.sync().runRepeating(this, 0L, 1L);
        }

        @Override
        public void run() {
            if (this.iteration > this.duration) {
                this.task.terminate();
            } else {
                this.yaw = (this.yaw + (float)this.velocity) % 360.0f;
                AbstractLocation l = this.target.getLocation();
                Vector v = this.target.getBukkitEntity().getVelocity();
                v.setY(v.getY() + 0.01);
                l.setYaw(this.yaw);
                this.target.teleport(l);
                this.target.getBukkitEntity().setVelocity(v);
                ++this.iteration;
            }
        }
    }
}

