/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

@MythicMechanic(author="Ashijin", name="effect:smokeswirl", aliases={"smokeswirl", "e:smokeswirl"})
public class SmokeSwirlEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int duration;
    protected int interval;

    public SmokeSwirlEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 5);
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 1);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(BukkitAdapter.adapt(target), this.interval, this.duration);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(BukkitAdapter.adapt(target), this.interval, this.duration);
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable {
        private Entity entity;
        private Location location;
        private int interval;
        private int duration;
        private int iteration;
        private int taskId;
        private int[] x = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        private int[] z = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        private int[] v = new int[]{7, 6, 3, 0, 1, 2, 5, 8};

        public Animator(Location location, int interval, int duration) {
            this(interval, duration);
            this.location = location;
        }

        public Animator(Entity entity, int interval, int duration) {
            this(interval, duration);
            this.entity = entity;
        }

        protected Animator(int interval, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.iteration = 0;
            this.taskId = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MythicBukkit.inst(), (Runnable)this, 0L, (long)interval);
        }

        @Override
        public void run() {
            if (this.iteration * this.interval > this.duration) {
                Bukkit.getScheduler().cancelTask(this.taskId);
            } else {
                int i = this.iteration % 8;
                Location loc = this.location != null ? this.location : this.entity.getLocation();
                loc.getWorld().playEffect(loc.clone().add((double)this.x[i], 0.0, (double)this.z[i]), Effect.SMOKE, this.v[i]);
                ++this.iteration;
            }
        }
    }
}

