/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import java.util.Optional;

public class SignalMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString signal;

    public SignalMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.signal = mlc.getPlaceholderString(new String[]{"signal", "s"}, "ping", new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Optional<ActiveMob> maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(target.getUniqueId());
        if (maybeMob.isPresent()) {
            String signal = this.signal.get(data, target);
            ActiveMob at = maybeMob.get();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending signal {0} to mob {1}", signal, at.getUniqueId());
            at.signalMob(data.getCaster().getEntity(), signal);
            return SkillResult.SUCCESS;
        }
        return SkillResult.INVALID_TARGET;
    }
}

