/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.HashSet;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

@MythicMechanic(author="Ashijin", name="shootshulkerbullet", aliases={"shootshulker"}, description="Shoots a shulker bullet at the target entity")
public class ShootShulkerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble damage;
    protected float startYOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected int tickInterval;
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected Boolean bounce;
    protected Boolean fromOrigin;
    protected Optional<String> disguise = Optional.empty();

    public ShootShulkerMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strProjectile = mlc.getString(new String[]{"type", "t"}, "arrow", new String[0]);
        this.damage = mlc.getPlaceholderDouble(new String[]{"damage", "d"}, 5.0, new String[0]);
        this.bounce = mlc.getBoolean(new String[]{"bounce"}, false);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo"}, 0.0f);
        this.startForwardOffset = mlc.getFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 0.0f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.disguise = Optional.ofNullable(mlc.getString(new String[]{"disguise", "d"}, null, new String[0]));
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onTickSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "ShootShulker Loaded onTick pointing at " + this.onTickSkillName, new Object[0]);
            if (this.onHitSkillName != null) {
                this.onHitSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onHit pointing at " + this.onHitSkillName, new Object[0]);
            if (this.onEndSkillName != null) {
                this.onEndSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onEndSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onEnd pointing at " + this.onEndSkillName, new Object[0]);
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target);
    }

    public SkillResult shoot(SkillMetadata data, AbstractEntity target) {
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin().clone();
        float power = data.getPower();
        if (!this.onTickSkill.isPresent() && this.onTickSkillName != null) {
            this.onTickSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onTickSkillName);
        }
        if (!this.onHitSkill.isPresent() && this.onHitSkillName != null) {
            this.onHitSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onHitSkillName);
        }
        if (!this.onEndSkill.isPresent() && this.onEndSkillName != null) {
            this.onEndSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.onEndSkillName);
        }
        if (this.startYOffset > 0.0f) {
            origin = origin.add(0.0, this.startYOffset, 0.0);
        }
        if (this.startForwardOffset != 0.0f) {
            origin = MythicUtil.move(origin, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            origin = MythicUtil.move(origin, 0.0, 0.0, this.startSideOffset);
        }
        AbstractEntity projectile = SkillAdapter.get().shootShulkerBullet(caster, target, origin, this);
        if (this.disguise.isPresent()) {
            ((MythicBukkit)this.getPlugin()).getCompatibility();
            if (CompatibilityManager.LibsDisguises.enabled) {
                Entity entity = BukkitAdapter.adapt(projectile);
                ((MythicBukkit)this.getPlugin()).getCompatibility();
                DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)CompatibilityManager.LibsDisguises.getParsedDisguise(this.disguise.get()));
            }
        }
        new ProjectileTracker(data, projectile, power);
        return SkillResult.SUCCESS;
    }

    public Boolean getBounce() {
        return this.bounce;
    }

    public Boolean getFromOrigin() {
        return this.fromOrigin;
    }

    protected class ProjectileTracker
    implements Runnable,
    Terminable {
        private final TerminableRegistry registry = TerminableRegistry.create();
        private SkillMetadata data;
        private SkillCaster caster;
        private AbstractEntity projectile;
        private boolean hasEnded = false;
        private float power;

        public ProjectileTracker(SkillMetadata caster, AbstractEntity projectile, float power) {
            this.caster = caster.getCaster();
            this.data = caster.deepClone();
            this.data.setIsAsync(true);
            this.projectile = projectile;
            this.power = power;
            this.registry.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getDamager() instanceof ShulkerBullet).filter(event -> event.getEntity() instanceof LivingEntity).filter(event -> event.getDamager().getUniqueId().equals(projectile.getUniqueId())).handler(this::doHitSkill));
            this.registry.accept(Schedulers.async().runRepeating(this, 0L, (long)ShootShulkerMechanic.this.tickInterval));
        }

        @Override
        public void run() {
            if (!this.projectile.isValid() || this.projectile.getBukkitEntity() instanceof Projectile && ((Projectile)this.projectile.getBukkitEntity()).isOnGround()) {
                this.doEndSkill();
                this.close();
            }
            if (ShootShulkerMechanic.this.onTickSkill.isPresent() && ShootShulkerMechanic.this.onTickSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(this.projectile.getLocation().clone());
                sData.setLocationTargets(targets);
                sData.setOrigin(this.projectile.getLocation().clone());
                sData.setPower(this.power);
                ShootShulkerMechanic.this.onTickSkill.get().execute(sData);
            }
        }

        public void doHitSkill(EntityDamageByEntityEvent event) {
            this.close();
            Projectile projectile = (Projectile)event.getDamager();
            AbstractEntity proj = BukkitAdapter.adapt((Entity)projectile);
            AbstractEntity target = BukkitAdapter.adapt(event.getEntity());
            HashSet<AbstractEntity> t2 = Sets.newHashSet();
            t2.add(target);
            SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.ATTACK, this.caster, target, proj.getLocation(), t2, null, this.power);
            if (ShootShulkerMechanic.this.damage.get(this.data, target) == 0.0) {
                event.setCancelled(true);
            } else {
                event.setDamage(ShootShulkerMechanic.this.damage.get(this.data, target));
            }
            if (ShootShulkerMechanic.this.onHitSkill.isPresent() && ShootShulkerMechanic.this.onHitSkill.get().isUsable(meta)) {
                ShootShulkerMechanic.this.onHitSkill.get().execute(meta);
            }
        }

        private void doEndSkill() {
            if (!this.hasEnded && ShootShulkerMechanic.this.onEndSkill.isPresent()) {
                if (ShootShulkerMechanic.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                    targets.add(this.projectile.getLocation().clone());
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.projectile.getLocation().clone());
                    sData.setPower(this.power);
                    ShootShulkerMechanic.this.onEndSkill.get().execute(sData);
                }
                this.hasEnded = true;
            }
        }

        @Override
        public void close() {
            this.registry.terminate();
        }
    }
}

