/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

@MythicMechanic(author="MarcatoSound", name="shieldbreak", aliases={"disableshield"}, description="Breaks the target player's shield block.")
public class ShieldBreakMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private final PlaceholderInt duration;

    public ShieldBreakMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.setAsyncSafe(false);
        this.duration = PlaceholderInt.of(mlc.getString(new String[]{"duration", "d"}, "100", new String[0]));
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        if (!(entity instanceof Player)) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)entity;
        return this.breakShield(player, data);
    }

    private SkillResult breakShield(Player player, SkillMetadata data) {
        if (!player.isBlocking()) {
            return SkillResult.CONDITION_FAILED;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack shield = inv.getItemInMainHand();
        EquipmentSlot hand = EquipmentSlot.HAND;
        if (shield.getType() != Material.SHIELD) {
            shield = inv.getItemInOffHand();
            hand = EquipmentSlot.OFF_HAND;
        }
        if (shield.getType() != Material.SHIELD) {
            return SkillResult.CONDITION_FAILED;
        }
        player.setCooldown(Material.SHIELD, this.duration.get(data, data.getCaster().getEntity()));
        player.playSound(player.getLocation(), "minecraft:item.shield.block", 1.0f, 1.0f);
        player.playSound(player.getLocation(), "minecraft:item.shield.break", 1.0f, 1.0f);
        inv.setItem(hand, null);
        ItemStack finalShield = shield;
        EquipmentSlot finalHand = hand;
        Bukkit.getScheduler().runTaskLater((Plugin)MythicBukkit.inst(), () -> {
            ItemStack newHandItem = inv.getItem(finalHand);
            if (newHandItem != null && newHandItem.getType() != Material.AIR) {
                if (inv.firstEmpty() == -1) {
                    player.getWorld().dropItem(player.getLocation(), newHandItem);
                } else {
                    inv.addItem(new ItemStack[]{newHandItem});
                }
                inv.setItem(finalHand, null);
            }
            inv.setItem(finalHand, finalShield);
        }, 1L);
        return SkillResult.SUCCESS;
    }
}

