/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class SetTargetScoreMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString objective;
    private int value;

    public SetTargetScoreMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.objective = mlc.getPlaceholderString(new String[]{"objective", "obj", "o"}, "", new String[0]);
        this.value = mlc.getInteger(new String[]{"value", "v"});
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = scoreboard.getObjective(this.objective.get(data, target));
        if (objective == null) {
            objective = scoreboard.registerNewObjective(this.objective.get(data, target), "dummy");
        }
        if (target.isPlayer()) {
            objective.getScore(target.asPlayer().getName()).setScore(this.value);
        } else {
            objective.getScore(target.getUniqueId().toString()).setScore(this.value);
        }
        return SkillResult.SUCCESS;
    }
}

