/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="setname", description="Sets the casting mob's name")
public class SetNameMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    private PlaceholderString name;

    public SetNameMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.name = mlc.getPlaceholderString(new String[]{"name", "n"}, null, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (data.getCaster() instanceof ActiveMob) {
            String newName = this.name.get(data);
            ActiveMob caster = (ActiveMob)data.getCaster();
            caster.getEntity().setCustomName(newName);
            if (CompatibilityManager.LibsDisguises != null && caster.getType() != null && caster.getType().getDisguise() != null) {
                CompatibilityManager.LibsDisguises.setDisguiseName(caster.getEntity(), newName);
            }
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            String newName = this.name.get(data, target);
            ActiveMob caster = (ActiveMob)data.getCaster();
            caster.getEntity().setCustomName(newName);
            if (CompatibilityManager.LibsDisguises != null && caster.getType() != null && caster.getType().getDisguise() != null) {
                CompatibilityManager.LibsDisguises.setDisguiseName(caster.getEntity(), newName);
            }
        }
        return SkillResult.SUCCESS;
    }
}

