/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;

public class SetMaxHealthMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderDouble amount;
    private Mode mode;

    public SetMaxHealthMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "a"}, 1.0, new String[0]);
        String mode = mlc.getString(new String[]{"mode", "m"}, "STATIC", new String[0]);
        try {
            this.mode = Mode.valueOf(mode.toUpperCase());
        }
        catch (Error | Exception ex) {
            this.mode = Mode.STATIC;
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid mode");
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isLiving()) {
            switch (this.mode) {
                case STATIC: {
                    target.setMaxHealth(this.amount.get(data, target));
                    break;
                }
                case SCALE: {
                    double newMaxHealth = this.amount.get(data, target);
                    double oldHealth = target.getHealth();
                    double oldMaxHealth = target.getMaxHealth();
                    double percent = oldHealth / oldMaxHealth;
                    double newHealth = newMaxHealth * percent;
                    target.setMaxHealth(newMaxHealth);
                    target.setHealth(newHealth);
                    break;
                }
            }
        }
        return SkillResult.SUCCESS;
    }

    private static enum Mode {
        STATIC,
        SCALE;

    }
}

