/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class SetBlockTypeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private String strMaterial;
    private AbstractBlock block;

    public SetBlockTypeMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        BlockData blockData;
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strMaterial = mlc.getString(new String[]{"material", "mat", "m", "type", "t"}, "DIRT", new String[0]).toUpperCase();
        byte materialData = (byte)mlc.getInteger(new String[]{"materialdata", "md", "data", "dv"}, 0);
        if (this.strMaterial.startsWith("MMOITEMS:")) {
            ((MythicBukkit)this.getPlugin()).getCompatibility().getMMOItems().ifPresent(mmoItems -> Numbers.parseIntegerOpt(this.strMaterial.substring(9)).ifPresent(id -> {
                this.block = mmoItems.getMMOItemsBlock((int)id);
            }));
            return;
        }
        try {
            blockData = Bukkit.createBlockData((String)this.strMaterial.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            MythicLogger.errorMechanicConfig(this, mlc, "'Material' must be a valid Material type.");
            blockData = Material.DIRT.createBlockData();
        }
        this.block = new BukkitBlock(blockData);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.setBlock(data, target.getLocation());
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.setBlock(data, target);
        return SkillResult.SUCCESS;
    }

    protected void setBlock(SkillMetadata data, AbstractLocation target) {
        if (this.strMaterial.startsWith("MMOITEMS:")) {
            this.block.set(target);
        } else {
            this.block.set(target);
        }
    }
}

