/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;

public class SendTitleMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString title;
    protected PlaceholderString subtitle;
    protected int timeIn;
    protected int timeSt;
    protected int timeOt;

    public SendTitleMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.target_creative = true;
        this.title = mlc.getPlaceholderString(new String[]{"title", "t"}, null, new String[0]);
        this.subtitle = mlc.getPlaceholderString(new String[]{"subtitle", "st"}, null, new String[0]);
        if (this.title == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'title' attribute is required");
            this.title = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
        }
        if (this.subtitle == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'subtitle' attribute is required");
            this.subtitle = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
        }
        this.timeIn = mlc.getInteger("fadein", 1);
        this.timeIn = mlc.getInteger("fi", this.timeIn);
        this.timeSt = mlc.getInteger("duration", 1);
        this.timeSt = mlc.getInteger("d", this.timeSt);
        this.timeOt = mlc.getInteger("fadeout", 1);
        this.timeOt = mlc.getInteger("fo", this.timeOt);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        String t2 = this.title.get(data, target);
        String st = this.subtitle.get(data, target);
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        target.asPlayer().sendTitle(t2, st, this.timeIn, this.timeSt, this.timeOt);
        return SkillResult.SUCCESS;
    }
}

