/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="runaitargetselector", aliases={"aitarget"}, description="Modify an AI Target Selector of the caster")
public class RunAITargetSelectorMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected ArrayList<String> goal = new ArrayList();

    public RunAITargetSelectorMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String g2 = mlc.getString(new String[]{"aitargetselector", "targetselector", "target", "string", "s"}, null, new String[0]);
        if (g2 == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'goal' attribute is required.");
            return;
        }
        g2 = MythicLineConfigImpl.unparseBlock(g2);
        this.goal.add(g2);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!ConfigExecutor.EnableAIModifiers) {
            return SkillResult.INVALID_CONFIG;
        }
        ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getAIHandler().addTargetGoals((LivingEntity)BukkitAdapter.adapt(data.getCaster().getEntity()), this.goal);
        return SkillResult.SUCCESS;
    }
}

