/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="runaigoalselector", aliases={"aigoal", "aigoals"}, description="Modify an AI Goal Selector of the caster")
public class RunAIGoalSelectorMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected PlaceholderString goal;

    public RunAIGoalSelectorMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.goal = mlc.getPlaceholderString(new String[]{"aigoalselector", "goalselector", "goal", "string", "s"}, null, new String[0]);
        if (this.goal == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'goal' attribute is required.");
            return;
        }
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!ConfigExecutor.EnableAIModifiers) {
            return SkillResult.INVALID_CONFIG;
        }
        ArrayList<String> goals = Lists.newArrayList(this.goal.get(data));
        ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getAIHandler().addPathfinderGoals((LivingEntity)BukkitAdapter.adapt(data.getCaster().getEntity()), goals);
        return SkillResult.SUCCESS;
    }
}

