/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Wolf;

@MythicMechanic(author="Ashijin", name="removeowner", aliases={"clearowner"}, description="")
public class RemoveOwnerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public RemoveOwnerMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            double maxHealth = am.getEntity().getMaxHealth();
            double currentHealth = am.getEntity().getHealth();
            am.removeOwner();
            Entity entity = data.getCaster().getEntity().getBukkitEntity();
            if (entity instanceof Wolf) {
                ((Wolf)entity).setOwner(null);
                ((Wolf)entity).setTamed(false);
            } else if (entity instanceof Parrot) {
                ((Parrot)entity).setOwner(null);
                ((Parrot)entity).setTamed(false);
            } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Cat) {
                ((Cat)entity).setOwner(null);
                ((Cat)entity).setTamed(false);
            }
            am.getEntity().setMaxHealth(maxHealth);
            am.getEntity().setHealth(currentHealth);
            return SkillResult.SUCCESS;
        }
        return SkillResult.SUCCESS;
    }
}

