/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="pickupitem", aliases={}, description="Picks up the target item entity")
public class PickUpItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private boolean doFakeLooting;

    public PickUpItemMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.doFakeLooting = mlc.getBoolean(new String[]{"fakelooting", "fl"}, true);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!(target.getBukkitEntity() instanceof Item)) {
            return SkillResult.INVALID_TARGET;
        }
        AbstractEntity caster = data.getCaster().getEntity();
        if (!caster.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)caster.getBukkitEntity();
        Item item = (Item)target.getBukkitEntity();
        ItemStack stack = item.getItemStack();
        if (stack.getType() == Material.AIR) {
            return SkillResult.INVALID_TARGET;
        }
        if (this.doFakeLooting) {
            int id = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().spawnFakeItem(player, stack, target.getLocation());
            Schedulers.sync().runLater(() -> ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().collectFakeItem(player, id), 5L);
        }
        HashMap left = player.getInventory().addItem(new ItemStack[]{stack});
        for (ItemStack entry : left.values()) {
            item.getLocation().getWorld().dropItem(item.getLocation(), entry);
        }
        item.remove();
        return SkillResult.SUCCESS;
    }
}

