/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.RandomUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particlesphere", aliases={"particlesphere", "e:ps", "ps"})
public class ParticleSphereEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderInt points;
    private float radius;

    public ParticleSphereEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.points = this.amount;
        this.amount = PlaceholderInt.of("1");
        this.radius = mlc.getFloat("radius", 0.0f);
        this.radius = mlc.getFloat("r", this.radius);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractEntity> audience = this.audience.get(data, null);
        this.playParticleSphereEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractEntity> audience = this.audience.get(data, target);
        this.playParticleSphereEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleSphereEffect(SkillMetadata data, AbstractLocation t2, Collection<AbstractEntity> audience) {
        AbstractLocation target = t2;
        AbstractLocation location = target.clone();
        if (this.setYaw) {
            location.setYaw(this.yaw);
        }
        if (this.setPitch) {
            location.setPitch(this.pitch);
        }
        location.add(0.0, this.yOffset.get(data), 0.0);
        int points = this.points.get(data);
        for (int i = 0; i < points; ++i) {
            AbstractVector vector = RandomUtil.getRandomVector().multiply(this.radius);
            location.add(vector);
            if (this.directional) {
                this.playDirectionalParticleEffect(data, target, target, location, audience);
            } else {
                this.playParticleEffect(data, location, audience);
            }
            location.subtract(vector);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractEntity> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed.get(data), 1, this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), direction);
            }
        } else {
            AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread.get(data)) + Numbers.randomDouble() * (double)this.xSpread.get(data) * 2.0, (double)this.vSpread.get(data) + Numbers.randomDouble() * (double)this.vSpread.get(data) * 2.0, (double)(0.0f - this.zSpread.get(data)) + Numbers.randomDouble() * (double)this.zSpread.get(data) * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed.get(data), 1, true).send(ln, this.viewDistance);
        }
    }
}

