/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.RandomUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particlebox", aliases={"particlebox", "e:pb", "pb"})
public class ParticleBoxEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float radius;

    public ParticleBoxEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, 5.0f);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractEntity> audience = this.audience.get(data, null);
        this.playParticleBoxEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractEntity> audience = this.audience.get(data, target);
        this.playParticleBoxEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleBoxEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        AbstractLocation location = target.clone();
        location.add(0.0, this.yOffset.get(data), 0.0);
        int amount = this.amount.get(data);
        for (int i = 0; i < amount; ++i) {
            AbstractVector vector = RandomUtil.getRandomVector().multiply(this.radius);
            location.add(vector);
            this.playParticleEffect(data, location, audience);
            location.subtract(vector);
        }
    }
}

