/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import eu.asangarin.mythickeys.api.MythicKeyReleaseEvent;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Optional;

@MythicMechanic(author="Phil", name="onKeyRelease", aliases={"keyRelease", "kr"}, description="Applies an aura to the targeted entity that triggers a skill when a key is released")
public class OnKeyReleaseMechanic
extends Aura
implements ITargetedEntitySkill {
    private String keyId;
    private String onReleaseSkillName;
    private Optional<Skill> onReleaseSkill = Optional.empty();

    public OnKeyReleaseMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.onReleaseSkillName = mlc.getString(new String[]{"onRelease", "or"});
        this.keyId = mlc.getString(new String[]{"key", "k"}).toLowerCase();
        this.keyId = SkillString.parseMessageSpecialChars(this.keyId);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.onReleaseSkillName != null) {
                this.onReleaseSkill = MythicBukkit.inst().getSkillManager().getSkill(this.onReleaseSkillName);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!((MythicBukkit)this.getPlugin()).getCompatibility().getMythicKeys().isPresent()) {
            return SkillResult.MISSING_COMPATIBILITY;
        }
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        new Tracker(target, data);
        return SkillResult.SUCCESS;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(AbstractEntity entity, SkillMetadata data) {
            super((Aura)OnKeyReleaseMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(MythicKeyReleaseEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).filter(event -> event.getId().toString().equalsIgnoreCase(OnKeyReleaseMechanic.this.keyId)).handler(event -> {
                SkillMetadata data = this.skillMetadata.deepClone();
                data.setTrigger(BukkitAdapter.adapt(event.getPlayer()));
                if (this.executeAuraSkill(OnKeyReleaseMechanic.this.onReleaseSkill, data)) {
                    this.consumeCharge();
                }
            }));
            this.executeAuraSkill(OnKeyReleaseMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

