/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitTriggerMetadata;
import io.lumine.mythic.bukkit.events.MythicProjectileHitEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="ondamaged", description="Applies an aura to the target that triggers a skill when they take damage")
public class OnDamagedMechanic
extends Aura
implements ITargetedEntitySkill {
    protected Optional<Skill> onDamagedSkill = Optional.empty();
    protected String onAttackSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.6", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelDamage;
    protected boolean modDamage = false;
    protected boolean deflect = false;
    @MythicField(name="damageSub", aliases={"s"}, defValue="0", version="4.6", description="")
    protected PlaceholderDouble damageSub;
    @MythicField(name="damageMultiplier", aliases={"m"}, defValue="1", version="4.6", description="")
    protected PlaceholderDouble damageMult;
    private Map<String, Double> damageModifiers = new HashMap<String, Double>();
    protected String deflectConditionsString;
    @MythicField(name="conditions", aliases={"cond", "c"}, defValue="NONE", version="5.1", description="Conditions applied to the caster when triggered")
    protected List<SkillCondition> deflectConditions = null;

    public OnDamagedMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.onAttackSkillName = mlc.getString(new String[]{"ondamagedskill", "ondamaged", "od", "onhitskill", "onhit", "oh"});
        this.cancelDamage = mlc.getBoolean(new String[]{"cancelevent", "ce", "canceldamage", "cd"}, false);
        String damageSub = mlc.getString(new String[]{"damagesub", "sub", "s"}, null, new String[0]);
        String damageMult = mlc.getString(new String[]{"damagemultiplier", "multiplier", "m"}, null, new String[0]);
        this.deflect = mlc.getBoolean(new String[]{"deflectProjectiles", "deflect", "reflect"}, false);
        this.damageSub = damageSub == null ? PlaceholderDouble.of("0") : PlaceholderDouble.of(damageSub);
        this.damageMult = damageMult == null ? PlaceholderDouble.of("1") : PlaceholderDouble.of(damageMult);
        PlaceholderString strDamageMod = mlc.getPlaceholderString(new String[]{"damagemodifiers", "damagemods", "damagemod"}, null, new String[0]);
        if (strDamageMod != null) {
            String[] lstDamageMod;
            for (String dm : lstDamageMod = strDamageMod.toString().split(",")) {
                try {
                    block7: {
                        try {
                            if (MythicBukkit.isVolatile()) break block7;
                            EntityDamageEvent.DamageCause.valueOf((String)dm.toUpperCase());
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.errorMechanicConfig(this, mlc, "Custom damage modifiers require MythicMobs Premium to use.");
                            continue;
                        }
                    }
                    String[] split = dm.split(" ");
                    String type = split[0];
                    double mod = Double.valueOf(split[1]);
                    this.damageModifiers.put(type, mod);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid syntax for DamageModifier");
                }
            }
        }
        if (damageSub != null || damageMult != null || this.damageModifiers.size() > 0) {
            this.modDamage = true;
        }
        this.deflectConditionsString = mlc.getString(new String[]{"deflectconditions", "dconditions"}, null, new String[0]);
        this.getManager().queueSecondPass(() -> {
            if (this.onAttackSkillName != null) {
                this.onDamagedSkill = MythicBukkit.inst().getSkillManager().getSkill(this.onAttackSkillName);
            }
            if (this.deflectConditionsString != null) {
                this.deflectConditions = this.getManager().getConditions(this.deflectConditionsString);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return SkillResult.SUCCESS;
    }

    protected double calculateDamage(SkillMetadata meta, AbstractEntity entity, EntityDamageEvent event) {
        DamageMetadata data;
        if (this.cancelDamage) {
            return 0.0;
        }
        double damage = event.getFinalDamage();
        Optional<Object> maybeData = entity.getMetadata("skill-damage");
        String damageType = maybeData.isPresent() ? ((data = (DamageMetadata)maybeData.get()).getElement() == null ? "SKILL" : data.getElement()) : event.getCause().toString();
        double mod = this.damageModifiers.getOrDefault(damageType.toUpperCase(), 1.0);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura: damageMod {0} has multiplier {1}", damageType, mod);
        return (damage - this.damageSub.get(meta, entity)) * this.damageMult.get(meta, entity) * mod;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnDamagedMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            if (OnDamagedMechanic.this.deflect) {
                this.registerAuraComponent(Events.subscribe(ProjectileHitEvent.class, EventPriority.HIGHEST).filter(event -> event.getHitEntity() != null).filter(event -> event.getHitEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                    SkillMetadata meta = this.skillMetadata.deepClone();
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (projectileHit) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                    if (OnDamagedMechanic.this.conditions != null) {
                        for (SkillCondition condition : OnDamagedMechanic.this.deflectConditions) {
                            if (condition.evaluateCaster(meta)) continue;
                            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                            return;
                        }
                    }
                    event.setCancelled(true);
                    Projectile proj = event.getEntity();
                    Vector velocity = proj.getVelocity();
                    Log.info("Velocity {0}, {1}, {2}", proj.getVelocity().getX(), proj.getVelocity().getY(), proj.getVelocity().getZ());
                    velocity.setX(velocity.getX() * -1.0);
                    velocity.setZ(velocity.getZ() * -1.0);
                    velocity.setY(velocity.getY() * -1.0);
                    Location location = proj.getLocation();
                    location.add(velocity.getX(), velocity.getY(), velocity.getZ());
                    proj.teleport(location);
                    proj.setVelocity(velocity);
                    Schedulers.sync().runLater(() -> proj.setVelocity(velocity), 1L);
                }));
                this.registerAuraComponent(Events.subscribe(MythicProjectileHitEvent.class, EventPriority.HIGHEST).filter(event -> event.getEntity() != null).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                    SkillMetadata meta = this.skillMetadata.deepClone();
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (mythicProjectileHit) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                    if (OnDamagedMechanic.this.conditions != null) {
                        for (SkillCondition condition : OnDamagedMechanic.this.deflectConditions) {
                            if (condition.evaluateCaster(meta)) continue;
                            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                            return;
                        }
                    }
                    event.setCancelled(true);
                    Projectile.ProjectileTracker projectile = event.getProjectile();
                    AbstractVector velocity = projectile.getCurrentVelocity();
                    velocity.setX(velocity.getX() * -1.25);
                    velocity.setZ(velocity.getZ() * -1.25);
                    velocity.setY(velocity.getY() * -1.25);
                    projectile.setCurrentVelocity(velocity);
                }));
            }
            this.registerAuraComponent(Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.HIGHEST).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                ProjectileSource ps;
                SkillMetadata meta = this.skillMetadata.deepClone();
                BukkitTriggerMetadata.apply(meta, (EntityDamageEvent)event);
                AbstractEntity damager = event.getDamager() instanceof LivingEntity ? BukkitAdapter.adapt(event.getDamager()) : (event.getDamager() instanceof Projectile ? ((ps = ((Projectile)event.getDamager()).getShooter()) instanceof LivingEntity ? BukkitAdapter.adapt((Entity)((LivingEntity)ps)) : null) : null);
                if (damager != null) {
                    meta.setTrigger(damager);
                }
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (byEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (this.executeTargetedAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta, BukkitAdapter.adapt(event.getEntity()))) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        double damage = OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                        event.setDamage(damage);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.registerAuraComponent(Events.subscribe(EntityDamageEvent.class, EventPriority.HIGHEST).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt(event.getEntity()));
                BukkitTriggerMetadata.apply(meta, event);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (nonEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (OnDamagedMechanic.this.conditions != null) {
                    for (SkillCondition condition : OnDamagedMechanic.this.conditions) {
                        if (condition.evaluateCaster(meta)) continue;
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                        return;
                    }
                }
                if (this.executeAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta)) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        double damage = OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                        event.setDamage(damage);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.executeAuraSkill(OnDamagedMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

