/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="mount", aliases={"vehicle"}, description="Summons a vehicle for the caster")
public class MountMechanic
extends SkillMechanic
implements INoTargetSkill {
    private PlaceholderString strType;

    public MountMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getPlaceholderString(new String[]{"mob", "m", "type", "t"}, "", new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        MythicMob mount = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(this.strType.get(data)).orElseGet(() -> null);
        if (mount == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'mob' attribute must be a valid MythicMob.");
            return SkillResult.INVALID_CONFIG;
        }
        AbstractEntity me = mount.spawn(data.getCaster().getEntity().getLocation(), data.getCaster().getLevel(), SpawnReason.SUMMON).getEntity();
        if (me == null) {
            return SkillResult.ERROR;
        }
        me.setPassenger(data.getCaster().getEntity());
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(me.getUniqueId()).get().setOwner(data.getCaster().getEntity().getUniqueId());
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(me.getUniqueId()).get().setParent(data.getCaster());
        return SkillResult.SUCCESS;
    }
}

