/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.mechanics.MissileMechanic;
import io.lumine.mythic.core.skills.mechanics.OrbitalMechanic;
import io.lumine.mythic.core.skills.mechanics.ProjectileMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="modifyprojectile", description="Modifies an attribute of the projectile that executed the mechanic")
public class ModifyProjectileMechanic
extends SkillMechanic
implements INoTargetSkill {
    private ProjectileTrait trait;
    private ModifyAction action;
    private PlaceholderDouble value;

    public ModifyProjectileMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        String t2 = mlc.getString(new String[]{"trait", "t"}, "VELOCITY", new String[0]);
        try {
            this.trait = ProjectileTrait.valueOf(t2.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String a = mlc.getString(new String[]{"action", "a"}, "MULTIPLY", new String[0]);
        try {
            this.action = ModifyAction.valueOf(a.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.value = mlc.getPlaceholderDouble(new String[]{"value", "v"}, 0.0, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (data.getCallingEvent() instanceof ProjectileMechanic.ProjectileMechanicTracker) {
            ProjectileMechanic.ProjectileMechanicTracker projectile = (ProjectileMechanic.ProjectileMechanicTracker)data.getCallingEvent();
            if (this.action == ModifyAction.SET) {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.setVelocity(this.value.get(data));
                        break;
                    }
                    case POWER: {
                        projectile.setPower((float)this.value.get(data));
                        break;
                    }
                    case GRAVITY: {
                        projectile.setGravity((float)this.value.get(data));
                        break;
                    }
                }
            } else {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.modifyVelocity(this.value.get(data));
                        break;
                    }
                    case POWER: {
                        projectile.modifyPower((float)this.value.get(data));
                        break;
                    }
                    case GRAVITY: {
                        projectile.modifyGravity((float)this.value.get(data));
                        break;
                    }
                }
            }
        } else if (data.getCallingEvent() instanceof MissileMechanic.MissileTracker) {
            MissileMechanic.MissileTracker projectile = (MissileMechanic.MissileTracker)data.getCallingEvent();
            if (this.action == ModifyAction.SET) {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.setVelocity(this.value.get(data));
                        break;
                    }
                    case POWER: {
                        projectile.setPower((float)this.value.get(data));
                        break;
                    }
                    case INERTIA: {
                        projectile.setInertia((float)this.value.get(data));
                        break;
                    }
                }
            } else {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.modifyVelocity(this.value.get(data));
                        break;
                    }
                    case POWER: {
                        projectile.modifyPower((float)this.value.get(data));
                        break;
                    }
                    case INERTIA: {
                        projectile.modifyInertia((float)this.value.get(data));
                        break;
                    }
                }
            }
        } else if (data.getCallingEvent() instanceof OrbitalMechanic.OrbitalTracker) {
            OrbitalMechanic.OrbitalTracker projectile = (OrbitalMechanic.OrbitalTracker)data.getCallingEvent();
            if (this.action == ModifyAction.SET) {
                switch (this.trait) {
                    case RADIUS: {
                        projectile.setRadius((float)this.value.get(data));
                        break;
                    }
                    case POWER: {
                        break;
                    }
                }
            } else {
                switch (this.trait) {
                    case RADIUS: {
                        projectile.modifyRadius((float)this.value.get(data));
                        break;
                    }
                    case POWER: {
                        break;
                    }
                }
            }
        }
        return SkillResult.SUCCESS;
    }

    private static enum ProjectileTrait {
        INERTIA,
        GRAVITY,
        POWER,
        VELOCITY,
        RADIUS;

    }

    private static enum ModifyAction {
        MULTIPLY,
        SET;

    }
}

