/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.utils.BlockUtil;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="missile", aliases={"mi"}, description="Shoots a homing missile at the target")
public class MissileMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float projectileInertia;

    public MissileMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, true);
        this.projectileInertia = mlc.getFloat(new String[]{"intertia", "inertia", "in"}, 1.5f);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new MissileTracker(data, target).start();
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new MissileTracker(data, target).start();
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    public class MissileTracker
    extends Projectile.ProjectileTracker {
        protected float inertia;
        protected AbstractEntity target;
        protected AbstractLocation targetLocation;
        protected float velocity;
        protected double targetYOffset;

        public MissileTracker(SkillMetadata data, AbstractEntity target) {
            super(MissileMechanic.this, data, target.getLocation());
            this.target = null;
            this.targetLocation = null;
            this.target = target;
            this.targetLocation = target.getLocation();
            this.inertia = MissileMechanic.this.projectileInertia;
        }

        public MissileTracker(SkillMetadata data, AbstractLocation target) {
            super(MissileMechanic.this, data, target);
            this.target = null;
            this.targetLocation = null;
            this.target = null;
            this.targetLocation = target;
            this.inertia = MissileMechanic.this.projectileInertia;
        }

        public AbstractLocation getTarget() {
            if (this.target != null) {
                return this.target.getLocation();
            }
            return this.targetLocation.clone();
        }

        @Override
        public void projectileStart() {
            double sso;
            this.velocity = MissileMechanic.this.projectileVelocity.get(this.data) / MissileMechanic.this.ticksPerSecond;
            this.startLocation = MissileMechanic.this.fromOrigin ? this.data.getOrigin().clone() : this.data.getCaster().getEntity().getLocation().clone();
            double tyo = MissileMechanic.this.getTargetYOffset().get(this.data);
            this.targetYOffset = this.target != null ? (tyo == 0.0 ? this.target.getEyeLocation().getY() - this.target.getLocation().getY() : tyo) : tyo;
            double syo = MissileMechanic.this.startYOffset.get(this.data);
            if (syo != 0.0) {
                this.startLocation.setY(this.startLocation.getY() + syo);
            }
            if (MissileMechanic.this.startForwardOffset.get(this.data) * -1.0f != 0.0f) {
                this.startLocation = MythicUtil.move(this.startLocation, MissileMechanic.this.startForwardOffset.get(this.data) * -1.0f, 0.0, 0.0);
            }
            if ((sso = MissileMechanic.this.startSideOffset.get(this.data)) != 0.0) {
                this.startLocation = MythicUtil.move(this.startLocation, 0.0, 0.0, sso);
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            if (MissileMechanic.this.projectileStartDirection.isPresent()) {
                AbstractLocation startVectorTarget = ((MythicBukkit)MissileMechanic.this.getPlugin()).getSkillManager().getLocationTarget((SkillTargeter)MissileMechanic.this.projectileStartDirection.get(), this.data);
                this.currentVelocity = startVectorTarget.toVector().rotate(0.001f).subtract(this.currentLocation.toVector()).normalize();
            } else {
                this.currentVelocity = this.getTarget().toVector().rotate(0.001f).subtract(this.currentLocation.toVector()).normalize();
            }
            this.currentLocation.setDirection(this.currentVelocity);
            if (MissileMechanic.this.projectileVelocityHorizOffset.get(this.data) != 0.0f || MissileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                float noise = 0.0f;
                if (MissileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                    noise = (float)((double)MissileMechanic.this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)MissileMechanic.this.projectileVelocityHorizNoise);
                }
                this.currentVelocity.rotate(MissileMechanic.this.projectileVelocityHorizOffset.get(this.data) + noise);
            }
            if (MissileMechanic.this.projectileVelocityVertOffset.get(this.data) != 0.0f || MissileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                float noise = 0.0f;
                if (MissileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                    noise = (float)((double)MissileMechanic.this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)MissileMechanic.this.projectileVelocityVertNoise);
                }
                this.currentVelocity.add(new AbstractVector(0.0f, MissileMechanic.this.projectileVelocityVertOffset.get(this.data) + noise, 0.0f)).normalize();
            }
            if (MissileMechanic.this.powerAffectsVelocity) {
                this.velocity *= this.power;
            }
            this.currentVelocity.multiply(this.velocity);
        }

        @Override
        public void projectileTick() {
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            this.currentVelocity.multiply(this.inertia);
            this.currentVelocity.add(this.getTarget().add(0.0, this.targetYOffset, 0.0).subtract(this.currentLocation.getX(), this.currentLocation.getY(), this.currentLocation.getZ()).toVector().normalize());
            this.currentVelocity.normalize().multiply(this.velocity);
            if (MissileMechanic.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock(), this)) {
                this.terminate();
                return;
            }
            if (this.target != null && (this.target.isDead() || !this.target.isValid())) {
                this.terminate();
                return;
            }
            if (this.bullet != null) {
                this.applyBulletVelocity();
            }
            if (MissileMechanic.this.onTickSkill.isPresent() && ((Skill)MissileMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = MissileMechanic.this.bulletType == Projectile.BulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                ((Skill)MissileMechanic.this.onTickSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
            }
            this.evaluateTargetsInBB();
            if (this.targets.size() > 0) {
                this.doHit((Collection)this.targets.clone());
            }
            this.targets.clear();
        }

        public void setVelocity(double value) {
            this.velocity = (float)value;
        }

        public void modifyVelocity(double v) {
            this.velocity = (float)((double)this.velocity * v);
        }

        public void setInertia(float p) {
            this.inertia = p;
        }

        public void modifyInertia(float p) {
            this.inertia *= p;
        }

        public void doHit(Collection<AbstractEntity> targets) {
            if (MissileMechanic.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)MissileMechanic.this.onHitSkill.get()).isUsable(sData)) {
                    ((Skill)MissileMechanic.this.onHitSkill.get()).execute(sData);
                }
            }
            if (MissileMechanic.this.stopOnHitEntity) {
                this.terminate();
            }
        }

        @Override
        public void applyBulletVelocity() {
            if (MissileMechanic.this.bulletType == Projectile.BulletType.ITEM) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 0.35, 0.0);
                ((MythicBukkit)MissileMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.previousLocation.toVector()));
            } else if (MissileMechanic.this.bulletType == Projectile.BulletType.ARROW) {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(0.25));
            } else if (MissileMechanic.this.bulletType == Projectile.BulletType.MOB) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                if (MissileMechanic.this.bulletSpin != 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + MissileMechanic.this.bulletSpin;
                    ol.setYaw(newSpin);
                }
                this.bullet.teleport(ol);
            } else if (MissileMechanic.this.bulletType == Projectile.BulletType.TRACKING) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 1.4375, 0.0);
                if (MissileMechanic.this.bulletSpin != 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + MissileMechanic.this.bulletSpin;
                    ol.setYaw(newSpin);
                    this.bullet.teleport(ol);
                } else {
                    this.orientBulletArmorStand();
                }
            } else {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                if (MissileMechanic.this.bulletSpin > 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + MissileMechanic.this.bulletSpin;
                    ((MythicBukkit)MissileMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                }
            }
        }
    }
}

